/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;

public abstract class ProxyBuilder<T> {
    public static <T> ProxyBuilder<T> builder(Class<T> iface, WebTarget webTarget) {
        try {
            Class<?> clazz;
            ClassLoader loader = null;
            if (System.getSecurityManager() == null) {
                loader = Thread.currentThread().getContextClassLoader();
            } else {
                try {
                    loader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException(pae);
                }
            }
            if (loader == null) {
                loader = ProxyBuilder.class.getClassLoader();
            }
            try {
                clazz = loader.loadClass("org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl");
            }
            catch (ClassNotFoundException ignore) {
                clazz = ProxyBuilder.class.getClassLoader().loadClass("org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl");
            }
            Constructor<?> c = clazz.getConstructor(Class.class, WebTarget.class);
            return (ProxyBuilder)c.newInstance(iface, webTarget);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T proxy(Class<T> iface, WebTarget base, ProxyConfig config) {
        return ProxyBuilder.builder(iface, base).build(config);
    }

    public abstract ProxyBuilder<T> classloader(ClassLoader var1);

    public abstract ProxyBuilder<T> defaultProduces(MediaType var1);

    public abstract ProxyBuilder<T> defaultConsumes(MediaType var1);

    public abstract ProxyBuilder<T> defaultProduces(String var1);

    public abstract ProxyBuilder<T> defaultConsumes(String var1);

    public abstract T build(ProxyConfig var1);

    public abstract T build();
}

