/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.http.enricher.PaginationService;
import com.xebialabs.deployit.core.api.HostService;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.DeployedApplicationsRepository;
import com.xebialabs.deployit.repository.EnvironmentRepository;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\u0007\u000e\u0001iA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001dy\u0006A1A\u0005\u0002\u0001Daa\u001b\u0001!\u0002\u0013\t\u0007\"\u0002=\u0001\t\u0013I\bbBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t\t\b\u0001C!\u0003g\u0012q\u0002S8tiN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u001d=\t1!\u00199j\u0015\t\u0001\u0012#\u0001\u0003sKN$(B\u0001\n\u0014\u0003\u0011\u0019wN]3\u000b\u0005Q)\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cGA\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%M5\tQE\u0003\u0002\u000f#%\u0011q%\n\u0002\f\u0011>\u001cHoU3sm&\u001cW-A\u000bf]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011af\u000b\u0002\u0016\u000b:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z\u0003y!W\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+c%\u0011!g\u000b\u0002\u001f\t\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\\:SKB|7/\u001b;pef\f\u0011\u0003]1hS:\fG/[8o'\u0016\u0014h/[2f!\t)$)D\u00017\u0015\t9\u0004(\u0001\u0005f]JL7\r[3s\u0015\tI$(\u0001\u0003iiR\u0004(BA\u001e=\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003{y\na\u0001Z3qY>L(BA A\u0003\u001d!\u0017nZ5uC2T\u0011!Q\u0001\u0003C&L!a\u0011\u001c\u0003#A\u000bw-\u001b8bi&|gnU3sm&\u001cW-\u0001\nsKB|7/\u001b;pef\u0014Vm]8ve\u000e,\u0007C\u0001$H\u001b\u0005i\u0011B\u0001%\u000e\u0005I\u0011V\r]8tSR|'/\u001f*fg>,(oY3\u0002\rqJg.\u001b;?)\u0015YE*\u0014(P!\t1\u0005\u0001C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00030\u000b\u0001\u0007\u0001\u0007C\u00034\u000b\u0001\u0007A\u0007C\u0003E\u000b\u0001\u0007Q\t\u000b\u0002\u0006#B\u0011!+X\u0007\u0002'*\u0011A+V\u0001\u000bC:tw\u000e^1uS>t'B\u0001,X\u0003\u001d1\u0017m\u0019;pefT!\u0001W-\u0002\u000b\t,\u0017M\\:\u000b\u0005i[\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003q\u000b1a\u001c:h\u0013\tq6KA\u0005BkR|w/\u001b:fI\u0006A!/Z:q_:\u001cX-F\u0001b!\t\u0011\u0017.D\u0001d\u0015\t!W-A\u0002ta&T!AZ4\u0002\u0011I,7\u000f^3bgfT!\u0001[.\u0002\u000b)\u0014wn]:\n\u0005)\u001c'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u0003:fgB|gn]3!Q\t9Q\u000e\u0005\u0002om6\tqN\u0003\u0002\u0013a*\u0011\u0011O]\u0001\u0003eNT!a\u001d;\u0002\u0005]\u001c(\"A;\u0002\u000f)\f7.\u0019:uC&\u0011qo\u001c\u0002\b\u0007>tG/\u001a=u\u0003e\u0019\u0007.Z2l\u0013\u001a,6/\u001a:ICN\u0004VM]7jgNLwN\\:\u0015\u0007i\f9\u0001E\u0002|\u0003\u0007i\u0011\u0001 \u0006\u0003{z\f1!\u001e3n\u0015\tqqPC\u0002\u0002\u0002M\ta\u0001\u001d7vO&t\u0017bAA\u0003y\n\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u000f\u0005%\u0001\u00021\u0001\u0002\f\u00051\u0001n\\:u\u0013\u0012\u0004B!!\u0004\u0002 9!\u0011qBA\u000e!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b3\u00051AH]8pizR!!!\u0007\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005u\u0011qC\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005u\u0011qC\u0001\u0019M&tG\rR3qY>LX\rZ!qa2L7-\u0019;j_:\u001cHCCA\u0015\u0003\u000f\nI%!\u0014\u0002XA1\u00111FA\u0019\u0003ki!!!\f\u000b\u0007\u0005=r$\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003[\u0011A\u0001T5tiB!\u0011qGA\"\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012a\u00013u_*\u0019a\"a\u0010\u000b\u0007\u0005\u00053#\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003\u000b\nIDA\nD_:4\u0017nZ;sCRLwN\\%uK6LE\rC\u0004\u0002\n%\u0001\r!a\u0003\t\u000f\u0005-\u0013\u00021\u0001\u0002\f\u0005yA-\u001a9m_f,G-\u00119q\u001d\u0006lW\rC\u0004\u0002P%\u0001\r!!\u0015\u0002\rA\fw-\u001b8h!\u0011\t9$a\u0015\n\t\u0005U\u0013\u0011\b\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005e\u0013\u00021\u0001\u0002\\\u0005)qN\u001d3feB!\u0011qGA/\u0013\u0011\ty&!\u000f\u0003\u0011=\u0013H-\u001a:j]\u001e\fqcY8v]R,eN^5s_:lWM\u001c;t\u0005fDun\u001d;\u0015\r\u0005\u0015\u00141NA7!\ra\u0012qM\u0005\u0004\u0003Sj\"aB%oi\u0016<WM\u001d\u0005\b\u0003\u0013Q\u0001\u0019AA\u0006\u0011\u001d\tyG\u0003a\u0001\u0003\u0017\tq\"\u001a8wSJ|g.\\3oi:\u000bW.Z\u0001\u0016O\u0016$XI\u001c<je>tW.\u001a8ug\nK\bj\\:u))\t)(! \u0002\u0000\u0005\u0005\u00151\u0011\t\u0007\u0003W\t\t$a\u001e\u0011\t\u0005]\u0012\u0011P\u0005\u0005\u0003w\nID\u0001\bEKBdw._7f]RLeNZ8\t\u000f\u0005%1\u00021\u0001\u0002\f!9\u0011qN\u0006A\u0002\u0005-\u0001bBA(\u0017\u0001\u0007\u0011\u0011\u000b\u0005\b\u00033Z\u0001\u0019AA.Q\r\u0001\u0011q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011QR-\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u0012\u0006-%aB*feZL7-\u001a")
public class HostServiceImpl
implements HostService {
    private final EnvironmentRepository environmentRepository;
    private final DeployedApplicationsRepository deployedApplicationsRepository;
    private final PaginationService paginationService;
    private final RepositoryResource repositoryResource;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    private ConfigurationItem checkIfUserHasPermissions(String hostId) {
        return this.repositoryResource.read(hostId);
    }

    public List<ConfigurationItemId> findDeployedApplications(String hostId, String deployedAppName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.deployedApplicationsRepository.countByHost(hostId, deployedAppName)));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.deployedApplicationsRepository.findByHost(hostId, deployedAppName, paging, order)).asJava();
    }

    public Integer countEnvironmentsByHost(String hostId, String environmentName) {
        this.checkIfUserHasPermissions(hostId);
        return Predef$.MODULE$.int2Integer(this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName)));
    }

    public List<DeploymentInfo> getEnvironmentsByHost(String hostId, String environmentName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName))));
        return this.environmentRepository.listEnvironmentsByHost(hostId, Option$.MODULE$.apply((Object)environmentName), paging, order);
    }

    @Autowired
    public HostServiceImpl(EnvironmentRepository environmentRepository, DeployedApplicationsRepository deployedApplicationsRepository, PaginationService paginationService, RepositoryResource repositoryResource) {
        this.environmentRepository = environmentRepository;
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.paginationService = paginationService;
        this.repositoryResource = repositoryResource;
        this.response = null;
    }
}

