/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class UniqueIdentifierType
extends AbstractDataType {
    static final String UNIQUE_IDENTIFIER_TYPE = "uniqueidentifier";

    public UniqueIdentifierType() {
        super(UNIQUE_IDENTIFIER_TYPE, 1, UUID.class, false);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        return value.toString();
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        String value = resultSet.getString(column);
        try {
            return value != null && value.length() > 0 ? UUID.fromString(value) : null;
        }
        catch (IllegalArgumentException error) {
            throw new TypeCastException("Invalid UUID: " + value, error);
        }
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (value == null) {
            statement.setObject(column, null);
        } else {
            statement.setObject(column, value.toString());
        }
    }
}

