/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLModGeneratedColumnsStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasTableFunctionVisitor;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.shared.common.error.StandardException;

public final class InsertNode
extends DMLModGeneratedColumnsStatementNode {
    private ResultColumnList targetColumnList;
    private boolean deferred;
    public ValueNode checkConstraints;
    public boolean hasDeferrableCheckConstraints;
    public Properties targetProperties;
    public FKInfo fkInfo;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    public boolean autoincrementColumnSetToDEFAULT;

    InsertNode(QueryTreeNode queryTreeNode, ResultColumnList resultColumnList, ResultSetNode resultSetNode, MatchingClauseNode matchingClauseNode, Properties properties, OrderByList orderByList, ValueNode valueNode, ValueNode valueNode2, boolean bl, ContextManager contextManager) {
        super(resultSetNode, matchingClauseNode, InsertNode.getStatementType(properties), contextManager);
        this.setTarget(queryTreeNode);
        this.targetColumnList = resultColumnList;
        this.targetProperties = properties;
        this.orderByList = orderByList;
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
        this.hasJDBClimitClause = bl;
        this.getResultSetNode().setInsertSource();
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "INSERT";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public void bindStatement() throws StandardException {
        int n;
        Object object;
        int n2;
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindResultSetsWithTables(dataDictionary);
        this.verifyTargetTable();
        if (this.targetProperties != null) {
            this.verifyTargetProperties(dataDictionary);
        }
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        this.getResultColumnList();
        if (this.targetColumnList != null) {
            if (this.synonymTableName != null) {
                this.normalizeSynonymColumns(this.targetColumnList, this.targetTableName);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            if (this.targetTableDescriptor != null) {
                this.targetColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
            } else {
                this.targetColumnList.bindResultColumnsByName(this.targetVTI.getResultColumns(), this.targetVTI, this);
            }
            this.getCompilerContext().popCurrentPrivType();
        }
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
        boolean bl = this.resultSet instanceof UnionNode && ((UnionNode)this.resultSet).tableConstructor() || this.resultSet instanceof RowResultSetNode;
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        boolean bl2 = false;
        for (n2 = 0; n2 < resultColumnList.size(); ++n2) {
            object = resultColumnList.getResultColumn(n2 + 1);
            if (!((ResultColumn)object).wasDefaultColumn()) continue;
            bl2 = true;
        }
        this.resultSet.replaceOrForbidDefaults(this.targetTableDescriptor, this.targetColumnList, bl);
        super.bindExpressions();
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
            this.getCompilerContext().popCurrentPrivType();
        }
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        if (this.targetColumnList != null) {
            if (this.resultSet.getResultColumns().visibleSize() > this.targetColumnList.size()) {
                throw StandardException.newException((String)"42802", (Object[])new Object[0]);
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.targetColumnList);
            this.resultSet.setTableConstructorTypes(this.targetColumnList);
        } else {
            if (this.resultSet.getResultColumns().visibleSize() > this.resultColumnList.size()) {
                throw StandardException.newException((String)"42802", (Object[])new Object[0]);
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.resultColumnList);
            this.resultSet.setTableConstructorTypes(this.resultColumnList);
        }
        this.resultSet.bindResultColumns(fromList);
        n2 = this.resultSet.getResultColumns().visibleSize();
        object = this.getDataDictionary();
        if (this.targetColumnList != null ? this.targetColumnList.size() != n2 : this.targetTableDescriptor != null && this.targetTableDescriptor.getNumberOfColumns() != n2) {
            throw StandardException.newException((String)"42802", (Object[])new Object[0]);
        }
        boolean bl3 = true;
        int n3 = this.resultColumnList.size();
        int[] nArray = new int[n3];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        if (this.targetColumnList != null) {
            n = this.targetColumnList.size();
            int n4 = 0;
            while (n4 < n) {
                int n5 = ((ResultColumn)this.targetColumnList.elementAt(n4)).getColumnDescriptor().getPosition();
                if (n4 != n5 - 1) {
                    bl3 = false;
                }
                nArray[n5 - 1] = n4++;
            }
        } else {
            for (n = 0; n < this.resultSet.getResultColumns().visibleSize(); ++n) {
                nArray[n] = n;
            }
        }
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
            super.bindExpressions();
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        InsertNode.bindOffsetFetch(this.offset, this.fetchFirst);
        this.resultSet = this.enhanceAndCheckForAutoincrement(this.resultSet, bl3, nArray, bl2);
        this.resultColumnList.checkStorableExpressions(this.resultSet.getResultColumns());
        if (!this.resultColumnList.columnTypesAndLengthsMatch(this.resultSet.getResultColumns())) {
            this.resultSet = new NormalizeResultSetNode(this.resultSet, this.resultColumnList, null, false, this.getContextManager());
        }
        if (this.targetTableDescriptor != null) {
            ResultColumnList resultColumnList2 = this.resultSet.getResultColumns();
            resultColumnList2.copyResultColumnNames(this.resultColumnList);
            this.parseAndBindGenerationClauses(dataDictionary, this.targetTableDescriptor, resultColumnList2, this.resultColumnList, false, null);
            boolean[] blArray = new boolean[]{false};
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, resultColumnList2, null, null, true, blArray);
            this.hasDeferrableCheckConstraints = blArray[0];
            if (this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
                if (this.bulkInsertReplace && this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true)) {
                    throw StandardException.newException((String)"42Y38", (Object[])new Object[]{this.targetTableDescriptor.getQualifiedName()});
                }
            }
            this.getAffectedIndexes(this.targetTableDescriptor);
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = object.computeAutoincRowLocations(transactionController, this.targetTableDescriptor);
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(1, this.targetVTI, null, this.resultSet);
        }
        this.identitySequenceUUIDString = this.getUUIDofSequenceGenerator();
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
        this.getCompilerContext().popCurrentPrivType();
    }

    ResultSetNode enhanceAndCheckForAutoincrement(ResultSetNode resultSetNode, boolean bl, int[] nArray, boolean bl2) throws StandardException {
        if (!((resultSetNode = resultSetNode.enhanceRCLForInsert(this, bl, nArray)) instanceof UnionNode) || !((UnionNode)resultSetNode).tableConstructor()) {
            this.resultColumnList.forbidOverrides(resultSetNode.getResultColumns(), bl2);
        }
        return resultSetNode;
    }

    @Override
    int getPrivType() {
        return 3;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        if (this.targetTableDescriptor != null) {
            bl = this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor());
        }
        if (!bl) {
            bl = this.resultSet.referencesSessionSchema();
        }
        return bl;
    }

    private void verifyTargetProperties(DataDictionary dataDictionary) throws StandardException {
        String string = this.targetProperties.getProperty("insertMode");
        if (string != null) {
            String string2 = StringUtil.SQLToUpperCase(string);
            if (!string2.equals("BULKINSERT") && !string2.equals("REPLACE")) {
                throw StandardException.newException((String)"42X60", (Object[])new Object[]{string, this.targetTableName});
            }
            if (!this.verifyBulkInsert(dataDictionary, string2)) {
                this.targetProperties.remove("insertMode");
            } else {
                int n;
                String string3;
                this.bulkInsert = true;
                if (string2.equals("REPLACE")) {
                    this.bulkInsertReplace = true;
                }
                if ((string3 = this.targetProperties.getProperty("bulkFetch")) != null && (n = this.getIntProperty(string3, "bulkFetch")) <= 0) {
                    throw StandardException.newException((String)"42Y64", (Object[])new Object[]{String.valueOf(n)});
                }
            }
        }
    }

    private boolean verifyBulkInsert(DataDictionary dataDictionary, String string) throws StandardException {
        return true;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            long l = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            int n = this.targetTableDescriptor != null ? this.indexConglomerateNumbers.length : 0;
            StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[n];
            for (int i = 0; i < n; ++i) {
                staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
            }
            if (this.bulkInsert || this.targetTableDescriptor.getLockGranularity() == 'T') {
                this.lockMode = 7;
            }
            return this.getGenericConstantActionFactory().getInsertConstantAction(this.targetTableDescriptor, l, transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.indexNames, this.deferred, false, this.hasDeferrableCheckConstraints, this.targetTableDescriptor.getUUID(), this.lockMode, null, null, this.targetProperties, this.getFKInfo(), this.getTriggerInfo(), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.getIndexedCols(), null, null, null, this.resultSet.isOneRowResultSet(), this.autoincRowLocation, this.inMatchingClause(), this.identitySequenceUUIDString, this.autoincrementColumnSetToDEFAULT);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(1, this.deferred);
    }

    boolean[] getIndexedCols() throws StandardException {
        boolean[] blArray = new boolean[this.targetTableDescriptor.getNumberOfColumns()];
        for (int i = 0; i < this.indicesToMaintain.length; ++i) {
            int[] nArray = this.indicesToMaintain[i].getIndexDescriptor().baseColumnPositions();
            for (int j = 0; j < nArray.length; ++j) {
                blArray[nArray[j] - 1] = true;
            }
        }
        return blArray;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.resultSet.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        super.optimizeStatement();
        HasTableFunctionVisitor hasTableFunctionVisitor = new HasTableFunctionVisitor();
        this.accept(hasTableFunctionVisitor);
        if (hasTableFunctionVisitor.hasNode() && !this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor())) {
            this.requestBulkInsert();
        }
    }

    private void requestBulkInsert() {
        if (this.targetProperties == null) {
            this.targetProperties = new Properties();
        }
        String string = "insertMode";
        String string2 = "bulkInsert";
        if (this.targetProperties.getProperty(string) == null) {
            this.targetProperties.put(string, string2);
        }
        this.bulkInsert = true;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCodeForTemporaryTable(activationClassBuilder);
        this.generateParameterValueSet(activationClassBuilder);
        if (this.targetTableDescriptor != null) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            if (this.inMatchingClause()) {
                this.matchingClause.generateResultSetField(activationClassBuilder, methodBuilder);
            } else {
                this.resultSet.generate(activationClassBuilder, methodBuilder);
            }
            this.generateGenerationClauses(this.resultColumnList, this.resultSet.getResultSetNumber(), false, activationClassBuilder, methodBuilder);
            this.generateCheckConstraints(this.checkConstraints, activationClassBuilder, methodBuilder);
            if (this.bulkInsert) {
                ColumnDescriptorList columnDescriptorList = this.targetTableDescriptor.getColumnDescriptorList();
                ExecRowBuilder execRowBuilder = new ExecRowBuilder(columnDescriptorList.size(), false);
                for (int i = 0; i < columnDescriptorList.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)columnDescriptorList.get(i);
                    execRowBuilder.setColumn(i + 1, columnDescriptor.getType());
                }
                methodBuilder.push(activationClassBuilder.addItem(execRowBuilder));
            } else {
                methodBuilder.push(-1);
            }
            if (this.targetTableName.getSchemaName() == null) {
                methodBuilder.pushNull("java.lang.String");
            } else {
                methodBuilder.push(this.targetTableName.getSchemaName());
            }
            methodBuilder.push(this.targetTableName.getTableName());
            methodBuilder.callMethod((short)185, null, "getInsertResultSet", "org.apache.derby.iapi.sql.ResultSet", 6);
        } else {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            this.resultSet.generate(activationClassBuilder, methodBuilder);
            this.targetVTI.generate(activationClassBuilder, methodBuilder);
            methodBuilder.callMethod((short)185, null, "getInsertVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        }
    }

    @Override
    protected final int getStatementType() {
        return 1;
    }

    static int getStatementType(Properties properties) {
        String string;
        String string2;
        int n = 1;
        String string3 = string2 = properties == null ? null : properties.getProperty("insertMode");
        if (string2 != null && (string = StringUtil.SQLToUpperCase(string2)).equals("REPLACE")) {
            n = 2;
        }
        return n;
    }

    private void getAffectedIndexes(TableDescriptor tableDescriptor) throws StandardException {
        IndexLister indexLister = tableDescriptor.getIndexLister();
        this.indicesToMaintain = indexLister.getDistinctIndexRowGenerators();
        this.indexConglomerateNumbers = indexLister.getDistinctIndexConglomerateNumbers();
        this.indexNames = indexLister.getDistinctIndexNames();
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        CompilerContext compilerContext = this.getCompilerContext();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            compilerContext.createDependency(conglomerateDescriptorArray[i]);
        }
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.targetColumnList != null) {
            this.targetColumnList.accept(visitor);
        }
    }
}

