/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.wildfly.common.Assert;
import org.wildfly.common.lock.ExtendedLock;
import org.wildfly.common.lock.JDKSpecific;

public class SpinLock
implements ExtendedLock {
    private static final long ownerOffset;
    private volatile Thread owner;
    private int level;

    @Override
    public boolean isLocked() {
        return this.owner != null;
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.owner == Thread.currentThread();
    }

    @Override
    public boolean isFair() {
        return true;
    }

    @Override
    public void lock() {
        int spins = 0;
        while (true) {
            Thread owner;
            if ((owner = this.owner) == Thread.currentThread()) {
                ++this.level;
                return;
            }
            if (owner == null && JDKSpecific.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread())) {
                this.level = 1;
                return;
            }
            if (spins >= 1000) {
                Thread.yield();
                continue;
            }
            JDKSpecific.onSpinWait();
            ++spins;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        int spins = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread owner = this.owner;
            if (owner == Thread.currentThread()) {
                ++this.level;
                return;
            }
            if (owner == null && JDKSpecific.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread())) {
                this.level = 1;
                return;
            }
            if (spins >= 1000) {
                Thread.yield();
                continue;
            }
            JDKSpecific.onSpinWait();
            ++spins;
        }
    }

    @Override
    public boolean tryLock() {
        Thread owner = this.owner;
        if (owner == Thread.currentThread()) {
            ++this.level;
            return true;
        }
        if (owner == null && JDKSpecific.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread())) {
            this.level = 1;
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        Thread owner = this.owner;
        if (owner == Thread.currentThread()) {
            if (--this.level == 0) {
                this.owner = null;
            }
        } else {
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws UnsupportedOperationException {
        throw Assert.unsupported();
    }

    @Override
    public Condition newCondition() throws UnsupportedOperationException {
        throw Assert.unsupported();
    }

    static {
        try {
            ownerOffset = JDKSpecific.unsafe.objectFieldOffset(SpinLock.class.getDeclaredField("owner"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }
}

