package com.xebialabs.deployit.core.upgrade.configuration

import com.xebialabs.deployit.core.upgrade.configuration.common.FileConfigurationUpgrader

class DbAnonymizerConfigurationUpgrader extends FileConfigurationUpgrader {

  override def configurationFileDescription: String = "Database anonymizer"

  override def originalFilePaths: List[String] = List(
    s"$confFolder/db-anonymize.json",
    s"$centralConfFolder/xld-db-anonymizer.yaml")

  override def configurationPrefix: String = "deploy.db-anonymizer"

  override def destinationFileName: String = "deploy-db-anonymizer.yaml"
}
