package com.xebialabs.deployit.core.upgrade.configuration

import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class PluginsConfigurationUpgrader extends DeployConfUpgrader {

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.features.plugins")) {
      createYamlConfiguration(confFile, "xl.features.plugins", "deploy.plugins", classOf[Object])
    }
  }

  override def configurationFileDescription: String = "Plugins configuration"

  override def destinationFileName: String = "deploy-plugins.yaml"
}
