package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.ClusterProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class ClusterConfigurationUpgrader extends DeployConfUpgrader {
  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.cluster")) {
      createYamlConfiguration(confFile, "xl.cluster", "deploy.cluster", classOf[ClusterProperties])
    }
  }

  override def destinationFileName: String = "deploy-cluster.yaml"

  override def configurationFileDescription: String = "Cluster Configuration"
}
