package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.db.ReportingProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader
import com.xebialabs.deployit.util.PasswordEncrypter

class ReportingConfigurationUpgrader extends DeployConfUpgrader {

  override def configurationFileDescription: String = "Reporting"

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.reporting.database.db-url")) {

      def transformFn(config: ReportingProperties): ReportingProperties = {
        val dbPasswordKey = "xl.reporting.database.db-password"
        val password: String = if (confFile.hasPath(dbPasswordKey))
          PasswordEncrypter.getInstance().ensureDecrypted(confFile.getString(dbPasswordKey))
        else
          null
        config.database.setDbPassword(password)
        config
      }

      createYamlConfiguration(confFile, "xl.reporting", "xl.reporting", classOf[ReportingProperties], transformFn)
      encryptCentralConfigurationProperties()
    }
  }

  override def destinationFileName: String = "deploy-reporting.yaml"
}
