package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.{FileWatchConfiguration, PlannerConfiguration, SchedulerConfiguration, TaskerSystemProperties}

import java.io.File
import java.util
import java.util.Properties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.TaskerSystemPropertiesUpgrader.{FILE_WATCH_PATH, PLANNER_PATH, SCHEDULER_PATH, TASK_PATH}
import com.xebialabs.deployit.core.upgrade.configuration.common.ComposedConfUpgrader

class TaskerSystemPropertiesUpgrader extends ComposedConfUpgrader[TaskerSystemProperties] {

  override def destinationFileName: String = "deploy-task.yaml"

  override def configurationFileDescription: String = "Task"

  override protected def processXlDeployConf(xlDeployConf: Config, config: TaskerSystemProperties): TaskerSystemProperties = {
    var taskConfig: TaskerSystemProperties = config

    if (xlDeployConf.hasPath(TASK_PATH)) {
      taskConfig = getYamlConfig(xlDeployConf, TASK_PATH, classOf[TaskerSystemProperties])
    }

    if (xlDeployConf.hasPath(SCHEDULER_PATH)) {
      taskConfig.scheduler = getYamlConfig(xlDeployConf, SCHEDULER_PATH, classOf[SchedulerConfiguration])
    }

    if (xlDeployConf.hasPath(PLANNER_PATH)) {
      taskConfig.planner = getYamlConfig(xlDeployConf, PLANNER_PATH, classOf[PlannerConfiguration])
    }

    if (xlDeployConf.hasPath(FILE_WATCH_PATH)) {
      taskConfig.planner.fileWatch = getYamlConfig(xlDeployConf, FILE_WATCH_PATH, classOf[FileWatchConfiguration])
    }
    taskConfig
  }

  override protected def processDeployItConf(properties: Properties, config: TaskerSystemProperties): TaskerSystemProperties = config

  override protected def processCentralConfigYamlFile(map: util.Map[String, AnyRef], config: TaskerSystemProperties, addIfExistsFn: AddIfExistsFn): TaskerSystemProperties = config

  override protected def getInitialConfig: TaskerSystemProperties = new TaskerSystemProperties()

  override protected def listXlDeployConfPrefixes: List[String] = List(
    TASK_PATH, SCHEDULER_PATH, PLANNER_PATH, FILE_WATCH_PATH
  )

  override protected def yamlPrefix: String = "deploy.task"

  override protected def listInsourcedYamlFiles: List[File] = List()

  override protected def listDeployitConfKeyNames: List[String] = List()
}

object TaskerSystemPropertiesUpgrader {
  val TASK_PATH = "xl.task"
  val SCHEDULER_PATH = "xl.scheduler"
  val PLANNER_PATH = "xl.planner"
  val FILE_WATCH_PATH = "xl.file-watch"
}
