package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.ArtifactResolverProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class ArtifactResolverConfigurationUpgrader extends DeployConfUpgrader {
  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.artifact")) {
      createYamlConfiguration(confFile, "xl.artifact", "deploy.artifact", classOf[ArtifactResolverProperties])
    }
  }

  override def destinationFileName: String = "deploy-artifact-resolver.yaml"

  override def configurationFileDescription: String = "Artifact Resolver Configuration"
}