/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;

public final class BooleanDeserializerWithYesNoSupport
extends NumberDeserializers.PrimitiveOrWrapperDeserializer<Boolean> {
    private static final long serialVersionUID = 1L;
    public static final BooleanDeserializerWithYesNoSupport primitiveInstance = new BooleanDeserializerWithYesNoSupport(Boolean.TYPE, Boolean.FALSE);
    public static final BooleanDeserializerWithYesNoSupport wrapperInstance = new BooleanDeserializerWithYesNoSupport(Boolean.class, null);

    public static SimpleModule createModule() {
        SimpleModule booleanIgnoreCaseModule = new SimpleModule();
        booleanIgnoreCaseModule.addDeserializer(Boolean.class, (JsonDeserializer)wrapperInstance);
        booleanIgnoreCaseModule.addDeserializer(Boolean.TYPE, (JsonDeserializer)primitiveInstance);
        return booleanIgnoreCaseModule;
    }

    public BooleanDeserializerWithYesNoSupport(Class<Boolean> cls, Boolean nvl) {
        super(cls, LogicalType.OtherScalar, (Object)nvl, (Object)Boolean.FALSE);
    }

    public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (this._primitive) {
            return this._parseBooleanPrimitiveWithYesNo(p, ctxt);
        }
        return this._parseBooleanWithYesNo(p, ctxt, this._valueClass);
    }

    public Boolean deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (this._primitive) {
            return this._parseBooleanPrimitiveWithYesNo(p, ctxt);
        }
        return this._parseBooleanWithYesNo(p, ctxt, this._valueClass);
    }

    protected final boolean _parseBooleanPrimitiveWithYesNo(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p.currentTokenId()) {
            case 6: {
                text = p.getText();
                break;
            }
            case 7: {
                return Boolean.TRUE.equals(this._coerceBooleanFromInt(p, ctxt, Boolean.TYPE));
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return false;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p, (JsonDeserializer)this, Boolean.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p.nextToken();
                    boolean parsed = this._parseBooleanPrimitiveWithYesNo(p, ctxt);
                    this._verifyEndArrayForSingle(p, ctxt);
                    return parsed;
                }
            }
            default: {
                return (Boolean)ctxt.handleUnexpectedToken(Boolean.TYPE, p);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Boolean, Boolean.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return false;
        }
        if (act == CoercionAction.AsEmpty) {
            return false;
        }
        int len = (text = text.trim()).length();
        if (len == 4) {
            if (this._isTrue(text)) {
                return true;
            }
        } else if (len == 5) {
            if (this._isFalse(text)) {
                return false;
            }
        } else if (len == 3) {
            if (this._isYes(text)) {
                return true;
            }
        } else if (len == 2 && this._isNo(text)) {
            return false;
        }
        if (this._hasTextualNull(text)) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return false;
        }
        Boolean b = (Boolean)ctxt.handleWeirdStringValue(Boolean.TYPE, text, "only \"true\"/\"True\"/\"TRUE\" or \"false\"/\"False\"/\"FALSE\" recognized", new Object[0]);
        return Boolean.TRUE.equals(b);
    }

    protected final Boolean _parseBooleanWithYesNo(JsonParser p, DeserializationContext ctxt, Class<?> targetType) throws IOException {
        String text;
        switch (p.currentTokenId()) {
            case 6: {
                text = p.getText();
                break;
            }
            case 7: {
                return this._coerceBooleanFromInt(p, ctxt, targetType);
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                return null;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p, (JsonDeserializer)this, targetType);
                break;
            }
            case 3: {
                return (Boolean)this._deserializeFromArray(p, ctxt);
            }
            default: {
                return (Boolean)ctxt.handleUnexpectedToken(targetType, p);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Boolean, targetType);
        if (act == CoercionAction.AsNull) {
            return null;
        }
        if (act == CoercionAction.AsEmpty) {
            return false;
        }
        int len = (text = text.trim()).length();
        if (len == 4) {
            if (this._isTrue(text)) {
                return true;
            }
        } else if (len == 5) {
            if (this._isFalse(text)) {
                return false;
            }
        } else if (len == 3) {
            if (this._isYes(text)) {
                return true;
            }
        } else if (len == 2 && this._isNo(text)) {
            return false;
        }
        if (this._checkTextualNull(ctxt, text)) {
            return null;
        }
        return (Boolean)ctxt.handleWeirdStringValue(targetType, text, "only \"true\" or \"false\" or \"yes\" or \"no\" recognized", new Object[0]);
    }

    protected boolean _isYes(String text) {
        return "yes".equalsIgnoreCase(text);
    }

    protected boolean _isNo(String text) {
        return "no".equalsIgnoreCase(text);
    }
}

