package com.xebialabs.deployit.core.upgrade.configuration.common

import com.typesafe.config.Config

import java.io.File

object OidcUtils {
  val CLIENT_ID_KEY = List("deploy", "security", "auth", "providers", "oidc", "clientId")
  val SECURITY_AUTH_PROVIDERS_PATH = "xl.security.auth.providers.oidc"

  def isEnabled(xlDeployConf: Config, centralConfFolder: String): Boolean = {
    if (xlDeployConf.hasPath(SECURITY_AUTH_PROVIDERS_PATH)) {
      return true
    }
    val configFile = new File(s"$centralConfFolder/deploy-oidc.yaml")
    ConfigUtils.getValue(configFile, CLIENT_ID_KEY) match {
      case Some(value) => value.toString.nonEmpty
      case _ => false
    }
  }
}
