/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.DatabaseConfig;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ClassLoaderForLiquibase;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Configuration
@EnableTransactionManagement
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006m\u0001!\ta\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0006)\u0002!\ta\u000f\u0005\u0006-\u0002!Ia\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\u0006Y\u0002!\t!\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!a\u000b\u0001\t\u0003\tY\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u00022!9\u0011\u0011\n\u0001\u0005\n\u0005-saBAA/!\u0005\u00111\u0011\u0004\u0007-]A\t!!\"\t\rY\nB\u0011AAD\u0011\u001d\tI)\u0005C\u0001\u0003\u0017Cq!a+\u0012\t\u0013\ti\u000bC\u0004\u0002<F!\t!!0\u0003!M\u000bHnQ8oM&<WO]1uS>t'B\u0001\r\u001a\u0003\u0019\u0019wN\u001c4jO*\u0011!dG\u0001\u0005G>\u0014XM\u0003\u0002\u001d;\u0005AA-\u001a9m_fLGO\u0003\u0002\u001f?\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002A\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQs&D\u0001,\u0015\taS&A\u0003tY\u001a$$NC\u0001/\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0019,\u0005\u001daunZ4j]\u001e\f\u0011\u0002\u001f7e\u0007>tg-[4\u0011\u0005M\"T\"A\f\n\u0005U:\"!\u0003-mI\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011\u0001(\u000f\t\u0003g\u0001AQ!\r\u0002A\u0002I\na\"\\1j]\u0012\u000bG/Y*pkJ\u001cW-F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)A\u0002tc2T\u0011!Q\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0007z\u0012!\u0002R1uCN{WO]2fQ\u0011\u0019Q)\u0015*\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\u0011!jS\u0001\bG>tG/\u001a=u\u0015\taU*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0012\u0002\u0005\u0005\u0016\fg.A\u0007eKN$(o\\=NKRDw\u000eZ\u0011\u0002'\u0006)1\r\\8tK\u0006\u0019\"/\u001a9peRLgn\u001a#bi\u0006\u001cv.\u001e:dK\"\"A!R)S\u0003YIgn\u001d;sk6,g\u000e^3e\t\u0006$\u0018mU8ve\u000e,GC\u0001-c!\tI\u0006-D\u0001[\u0015\tYF,\u0001\u0003kI\n\u001c'BA/_\u0003\u001diW\r\u001e:jGNT!aX\u0010\u0002\u000bQ\fH-\u001a<\n\u0005\u0005T&AF%ogR\u0014X/\\3oi\u0016$G)\u0019;b'>,(oY3\t\u000b\r,\u0001\u0019\u0001\u001f\u0002\u0015\u0011\fG/Y*pkJ\u001cW-\u0001\bnC&t7+\u001d7ES\u0006dWm\u0019;\u0016\u0003\u0019\u0004\"aZ5\u000e\u0003!T!aP\r\n\u0005)D'AC*rY\u0012K\u0017\r\\3di\"\u0012a!R\u0001\u0014e\u0016\u0004xN\u001d;j]\u001e\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0015\u0003\u000f\u0015\u000b\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!AG:\u000b\u0005m[\u0015BA;s\u00051QEMY2UK6\u0004H.\u0019;fQ\tAQ)\u0001\u000bf]RLG/_'b]\u0006<WM\u001d$bGR|'/\u001f\u000b\u0002sB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0004UB\f'B\u0001@L\u0003\ry'/\\\u0005\u0004\u0003\u0003Y(\u0001I!cgR\u0014\u0018m\u0019;F]RLG/_'b]\u0006<WM\u001d$bGR|'/\u001f\"fC:D#!C#\u0002)\u0015D8-\u001a9uS>tGK]1og2\fG/[8o+\t\tI\u0001\u0005\u0003\u0002\f\u0005MQBAA\u0007\u0015\rA\u0015q\u0002\u0006\u0004\u0003#Y\u0015a\u00013b_&!\u0011QCA\u0007\u00051\u0002VM]:jgR,gnY3Fq\u000e,\u0007\u000f^5p]R\u0013\u0018M\\:mCRLwN\u001c)pgR\u0004&o\\2fgN|'\u000f\u000b\u0002\u000b\u000b\u00061R.Y5o)J\fgn]1di&|g.T1oC\u001e,'/\u0006\u0002\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$-\u000b1\u0002\u001e:b]N\f7\r^5p]&!\u0011qEA\u0011\u0005i\u0001F.\u0019;g_JlGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\tYQ)A\u000esKB|'\u000f^5oOR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0003\u0019\u0015\u000ba#\u001b8ji&\fG.\u001b>f\u001b\u0006Lg\u000eR1uC\n\f7/\u001a\u000b\u0003\u0003g\u00012\u0001JA\u001b\u0013\r\t9$\n\u0002\u0005+:LG\u000fK\u0002\u000e\u0003w\u0001B!!\u0010\u0002B5\u0011\u0011q\b\u0006\u0003\u0011\u0002KA!a\u0011\u0002@\ti\u0001k\\:u\u0007>t7\u000f\u001e:vGR\f1$\u001b8ji&\fG.\u001b>f%\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1cCN,\u0007f\u0001\b\u0002<\u0005yQ\u000f\u001d3bi\u0016d\u0015.];jE\u0006\u001cX\r\u0006\u0005\u00024\u00055\u0013qMA5\u0011\u001d\tye\u0004a\u0001\u0003#\naa]2iK6\f\u0007\u0003BA*\u0003CrA!!\u0016\u0002^A\u0019\u0011qK\u0013\u000e\u0005\u0005e#bAA.C\u00051AH]8pizJ1!a\u0018&\u0003\u0019\u0001&/\u001a3fM&!\u00111MA3\u0005\u0019\u0019FO]5oO*\u0019\u0011qL\u0013\t\u000b\r|\u0001\u0019\u0001\u001f\t\r\u0005-t\u00021\u0001g\u0003\u001d!\u0017.\u00197fGRD3\u0001AA8!\u0011\t\t(!\u001e\u000e\u0005\u0005M$b\u0001%\u0002\"%!\u0011qOA:\u0005m)e.\u00192mKR\u0013\u0018M\\:bGRLwN\\'b]\u0006<W-\\3oi\"\u001a\u0001!a\u001f\u0011\u0007\u0019\u000bi(C\u0002\u0002\u0000\u001d\u0013QbQ8oM&<WO]1uS>t\u0017\u0001E*rY\u000e{gNZ5hkJ\fG/[8o!\t\u0019\u0014c\u0005\u0002\u0012GQ\u0011\u00111Q\u0001\u0011Q&\\\u0017M]5ECR\f7k\\;sG\u0016$b!!$\u0002\u001e\u0006\u001d\u0006\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\u0007Q&\\\u0017M]5\u000b\u0007\u0005]u$\u0001\u0004{CbDXM]\u0005\u0005\u00037\u000b\tJ\u0001\tIS.\f'/\u001b#bi\u0006\u001cv.\u001e:dK\"9\u0011qT\nA\u0002\u0005\u0005\u0016\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0007M\n\u0019+C\u0002\u0002&^\u0011a\u0002R1uC\n\f7/Z\"p]\u001aLw\rC\u0004\u0002*N\u0001\r!!\u0015\u0002\t9\fW.Z\u0001\rQ&\\\u0017M]5D_:4\u0017n\u001a\u000b\u0007\u0003_\u000b),a.\u0011\t\u0005=\u0015\u0011W\u0005\u0005\u0003g\u000b\tJ\u0001\u0007IS.\f'/[\"p]\u001aLw\r\u0003\u0004\u0019)\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003s#\u0002\u0019AA)\u0003!\u0001xn\u001c7OC6,\u0017\u0001\u00057jcVL'-Y:f\u0007>tG/\u001a=u)\u0019\t\t&a0\u0002B\"1\u00111N\u000bA\u0002\u0019Dq!a1\u0016\u0001\u0004\t)-A\u0002d_:\u0004B!a2\u0002P6\u0011\u0011\u0011\u001a\u0006\u0004\u007f\u0005-'BAAg\u0003\u0011Q\u0017M^1\n\t\u0005E\u0017\u0011\u001a\u0002\u000b\u0007>tg.Z2uS>t\u0007")
public class SqlConfiguration
implements Logging {
    private final XldConfig xldConfig;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect sqlDialect, Connection connection) {
        return SqlConfiguration$.MODULE$.liquibaseContext(sqlDialect, connection);
    }

    public static HikariDataSource hikariDataSource(DatabaseConfig databaseConfig, String string) {
        return SqlConfiguration$.MODULE$.hikariDataSource(databaseConfig, string);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.repository().database(), "MainPool"));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.xldConfig.reporting().database(), "ReportingPool"));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect mainSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Detected SQL dialect for main: ").append(dialect).append(".").toString());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect reportingSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Detected SQL dialect for reporting: ").append(dialect).append(".").toString());
        return var1_1;
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new JdbcTemplate(this.mainDataSource());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public AbstractEntityManagerFactoryBean entityManagerFactory() {
        void var1_1;
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.mainDataSource());
        em.setPackagesToScan(new String[]{"com.xebialabs.deployit"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return var1_1;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-master.yaml", this.mainDataSource(), this.mainSqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-reporting.yaml", this.reportingDataSource(), this.reportingSqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderForLiquibase(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    public SqlConfiguration(XldConfig xldConfig) {
        this.xldConfig = xldConfig;
        Logging.$init$((Logging)this);
    }
}

