package com.xebialabs.database.anonymizer

import ai.digital.deploy.core.common.XldServerPaths
import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.{ServerConfigFile, ServerConfiguration}
import com.xebialabs.deployit.configuration.system.SystemValues
import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.ConfigurationPropertiesScan
import org.springframework.boot.{Banner, CommandLineRunner, SpringApplication, WebApplicationType}
import org.springframework.context.annotation.{ComponentScan, Configuration}

@ComponentScan(Array(
  "ai.digital.configuration.central.deploy",
  "com.xebialabs.database.anonymizer",
  "com.xebialabs.deployit.core.config.db"
))
@ConfigurationPropertiesScan(Array(
  "ai.digital.configuration.central.deploy",
  "com.xebialabs.database.anonymizer",
  "com.xebialabs.deployit.core.config.db"
))
@Configuration
class AnonymizerBootstrapper extends CommandLineRunner {

  @Autowired
  var importService: ImportService = _

  @Autowired
  var exportService: ExportService = _

  override def run(args: String*): Unit = {
    try {
      val options: AnonymizerOptions = AnonymizerOptions.parse(args: _*)
      if (options.dbImport) importService.start(options)
      else exportService.start(options.reportingDb)
      System.exit(0)
    } catch {
      case e: Exception =>
        e.printStackTrace()
        System.exit(1)
    }
  }
}

object AnonymizerBootstrapper {

  def main(args: Array[String]): Unit = {

    SystemValues
      .apply()
      .apply(AnonymizerActiveProfiles.all)
      .applyConfigClientOnlySystemValues()

    val passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey(null)
    PasswordEncrypter.init(passwordEncryptionKey)
    val config = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE).loadConfig(false, false, true)
    ServerConfiguration.setInstance(config)
    LocalBooter.boot() // required for the profile setup

    SystemValues.apply(ServerConfiguration.getInstance())

    val app = new SpringApplication(classOf[AnonymizerBootstrapper])
    app.setWebApplicationType(WebApplicationType.NONE)
    app.setBannerMode(Banner.Mode.OFF)
    app.run(args: _*)
  }
}
