/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.dto.ApplyPatchesInput;
import com.xebialabs.deployit.core.rest.api.dto.PatchedSample;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.model.InvalidActivator;
import com.xebialabs.deployit.model.InvalidActivators;
import com.xebialabs.deployit.model.InvalidPatchEntry;
import com.xebialabs.deployit.model.request.ValidateActivatorRequest;
import com.xebialabs.deployit.model.request.ValidateActivatorsRequest;
import com.xebialabs.deployit.model.request.ValidatePatchEntryRequest;
import com.xebialabs.deployit.plugin.service.FormatSupportProvider;
import com.xebialabs.deployit.plugin.service.PatchFormatSupport;
import com.xebialabs.deployit.plugin.service.PatchService;
import com.xebialabs.deployit.plugin.service.ValidationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Controller
@Autowired
@Path(value="/patch")
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011\u00151\u0004\u0001\"\u00018\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u0019\u0001\t\u0003\t\u0019GA\u0007QCR\u001c\u0007NU3t_V\u00148-\u001a\u0006\u0003\u00195\t1!\u00199j\u0015\tqq\"\u0001\u0003sKN$(B\u0001\t\u0012\u0003\u0011\u0019wN]3\u000b\u0005I\u0019\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u0006a\u0001/\u0019;dQN+'O^5dKB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\bg\u0016\u0014h/[2f\u0015\t)\u0013#\u0001\u0004qYV<\u0017N\\\u0005\u0003O\t\u0012A\u0002U1uG\"\u001cVM\u001d<jG\u0016\f\u0011\u0003]1hS:\fG/[8o'\u0016\u0014h/[2f!\tQC&D\u0001,\u0015\t\u0019s\"\u0003\u0002.W\t\t\u0002+Y4j]\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002#Y\fG.\u001b3bi&|gnU3sm&\u001cW\r\u0005\u0002\"a%\u0011\u0011G\t\u0002\u0012-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0017!\u00064pe6\fGoU;qa>\u0014H\u000f\u0015:pm&$WM\u001d\t\u0003CQJ!!\u000e\u0012\u0003+\u0019{'/\\1u'V\u0004\bo\u001c:u!J|g/\u001b3fe\u00061A(\u001b8jiz\"R\u0001\u000f\u001e<yu\u0002\"!\u000f\u0001\u000e\u0003-AQaH\u0003A\u0002\u0001BQ\u0001K\u0003A\u0002%BQAL\u0003A\u0002=BQAM\u0003A\u0002M\nQ!\u00199qYf$2\u0001\u0011$b!\t\tE)D\u0001C\u0015\t\u00195\"A\u0002ei>L!!\u0012\"\u0003\u001bA\u000bGo\u00195fIN\u000bW\u000e\u001d7f\u0011\u00159e\u00011\u0001I\u00039\u0019wN\u001c;f]R$\u0016\u0010]3FqR\u0004\"!\u0013)\u000f\u0005)s\u0005CA&\u001c\u001b\u0005a%BA'\u0018\u0003\u0019a$o\\8u}%\u0011qjG\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P7!\"a\t\u00160`!\t)F,D\u0001W\u0015\t9\u0006,\u0001\u0002sg*\u0011\u0011LW\u0001\u0003oNT\u0011aW\u0001\u0006U\u00064\u0018\r_\u0005\u0003;Z\u0013\u0011\u0002U1uQB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003\u0001\f1bY8oi\u0016tG\u000fV=qK\")!M\u0002a\u0001G\u0006!A-\u0019;b!\t\tE-\u0003\u0002f\u0005\n\t\u0012\t\u001d9msB\u000bGo\u00195fg&s\u0007/\u001e;)\t\u00199gL\u001b\t\u0003+\"L!!\u001b,\u0003\u0011A\u0013x\u000eZ;dKNd\u0013a[\u0011\u0002Y\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0005\r9t\u0016\u000f\u0005\u0002V_&\u0011\u0001O\u0016\u0002\t\u0007>t7/^7fg2\n1\u000e\u000b\u0003\u0007gz3\bCA+u\u0013\t)hK\u0001\u0003QCRD\u0017%A<\u0002'\u0005\u0004\b\u000f\\=0w\u000e|g\u000e^3oiRK\b/Z?)\u0005\u0019I\bCA+{\u0013\tYhK\u0001\u0003Q\u001fN#\u0016!\u0005<bY&$\u0017\r^3BGRLg/\u0019;peR)a0a\u0004\u0002\u0014A!!d`A\u0002\u0013\r\t\ta\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u0012\u0003\u0015iw\u000eZ3m\u0013\u0011\ti!a\u0002\u0003!%sg/\u00197jI\u0006\u001bG/\u001b<bi>\u0014\b\"B$\b\u0001\u0004A\u0005&BA\b)z{\u0006bBA\u000b\u000f\u0001\u0007\u0011qC\u0001\be\u0016\fX/Z:u!\u0011\tI\"!\b\u000e\u0005\u0005m!\u0002BA\u000b\u0003\u000fIA!a\b\u0002\u001c\tAb+\u00197jI\u0006$X-Q2uSZ\fGo\u001c:SKF,Xm\u001d;)\u000b\u001dqg,a\t-\u0003-DSaB:_\u0003O\t#!!\u000b\u0002AY\fG.\u001b3bi\u0016|\u0013m\u0019;jm\u0006$xN]\u0018|G>tG/\u001a8u)f\u0004X- \u0015\u0003\u000fe\f!C^1mS\u0012\fG/Z!di&4\u0018\r^8sgR1\u0011\u0011GA%\u0003\u001b\u0002b!a\r\u0002>\u0005\rc\u0002BA\u001b\u0003sq1aSA\u001c\u0013\u0005a\u0012bAA\u001e7\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u0012A\u0001T5ti*\u0019\u00111H\u000e\u0011\t\u0005\u0015\u0011QI\u0005\u0005\u0003\u000f\n9AA\tJ]Z\fG.\u001b3BGRLg/\u0019;peNDQa\u0012\u0005A\u0002!CS!!\u0013U=~Cq!!\u0006\t\u0001\u0004\ty\u0005\u0005\u0003\u0002\u001a\u0005E\u0013\u0002BA*\u00037\u0011\u0011DV1mS\u0012\fG/Z!di&4\u0018\r^8sgJ+\u0017/^3ti\"*\u0001B\u001c0\u0002X1\n1\u000eK\u0003\tgz\u000bY&\t\u0002\u0002^\u0005\tc/\u00197jI\u0006$XmL1di&4\u0018\r^8sg>Z8m\u001c8uK:$H+\u001f9f{\"\u0012\u0001\"_\u0001\u0013m\u0006d\u0017\u000eZ1uKB\u000bGo\u00195F]R\u0014\u0018\u0010\u0006\u0004\u0002f\u00055\u0014\u0011\u000f\t\u00055}\f9\u0007\u0005\u0003\u0002\u0006\u0005%\u0014\u0002BA6\u0003\u000f\u0011\u0011#\u00138wC2LG\rU1uG\",e\u000e\u001e:z\u0011\u00159\u0015\u00021\u0001IQ\u0015\ti\u0007\u00160`\u0011\u001d\t)\"\u0003a\u0001\u0003g\u0002B!!\u0007\u0002v%!\u0011qOA\u000e\u0005e1\u0016\r\\5eCR,\u0007+\u0019;dQ\u0016sGO]=SKF,Xm\u001d;)\u000b%qg,a\u001f-\u0003-DS!C:_\u0003\u007f\n#!!!\u00029Y\fG.\u001b3bi\u0016|SM\u001c;ss>Z8m\u001c8uK:$H+\u001f9f{\"\u0012\u0011\"\u001f\u0015\u0006\u0001Mt\u0016qQ\u0011\u0003\u0003\u0013\u000baa\f9bi\u000eD\u0007f\u0001\u0001\u0002\u000eB!\u0011qRAS\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015AC1o]>$\u0018\r^5p]*!\u0011qSAM\u0003\u001d1\u0017m\u0019;pefTA!a'\u0002\u001e\u0006)!-Z1og*!\u0011qTAQ\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAAR\u0003\ry'oZ\u0005\u0005\u0003O\u000b\tJA\u0005BkR|w/\u001b:fI\"\u001a\u0001!a+\u0011\t\u00055\u00161W\u0007\u0003\u0003_SA!!-\u0002\u001e\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0016q\u0016\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class PatchResource {
    private final PatchService patchService;
    private final ValidationService validationService;
    private final FormatSupportProvider formatSupportProvider;

    @POST
    @Path(value="apply/{contentType}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PatchedSample apply(@PathParam(value="contentType") String contentTypeExt, ApplyPatchesInput data) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.patchService.applyPatch(data.patchEntries(), data.sample(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activator/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidActivator> validateActivator(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivator(request.content(), request.activator(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/activators/{contentType}")
    @Consumes(value={"application/json"})
    public List<InvalidActivators> validateActivators(@PathParam(value="contentType") String contentTypeExt, ValidateActivatorsRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validateActivators(request.content(), request.activators(), patchFormatSupport);
    }

    @POST
    @Path(value="validate/entry/{contentType}")
    @Consumes(value={"application/json"})
    public Option<InvalidPatchEntry> validatePatchEntry(@PathParam(value="contentType") String contentTypeExt, ValidatePatchEntryRequest request) {
        PatchFormatSupport patchFormatSupport = this.formatSupportProvider.getExtensionSupport(contentTypeExt);
        return this.validationService.validatePatchEntry(request.content(), request.entry(), patchFormatSupport);
    }

    public PatchResource(PatchService patchService, PaginationService paginationService, ValidationService validationService, FormatSupportProvider formatSupportProvider) {
        this.patchService = patchService;
        this.validationService = validationService;
        this.formatSupportProvider = formatSupportProvider;
    }
}

