/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.service;

import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.deployit.plugin.service.ContentParsingException;
import com.xebialabs.deployit.plugin.service.ContentTooLargeException;
import com.xebialabs.deployit.plugin.service.DataProcessingException;
import com.xebialabs.deployit.plugin.service.FileIsTooLargeException;
import com.xebialabs.deployit.plugin.service.SampleContent;
import com.xebialabs.deployit.plugin.service.SampleContentService;
import com.xebialabs.deployit.plugin.service.SampleContentTransformer;
import com.xebialabs.deployit.plugin.service.SupportedContentType;
import com.xebialabs.deployit.plugin.service.SupportedContentType$;
import com.xebialabs.deployit.plugin.service.UnsupportedFileTypeException;
import com.xebialabs.deployit.plugin.service.WrongCITypeException;
import com.xebialabs.deployit.repository.RepositoryService;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003=\u0001\u0011%Q\bC\u0003L\u0001\u0011%A\nC\u0003e\u0001\u0011%Q\rC\u0003t\u0001\u0011\u0005C\u000fC\u0003w\u0001\u0011%q\u000fC\u0003~\u0001\u0011\u0005cPA\u000eEK\u001a\fW\u000f\u001c;TC6\u0004H.Z\"p]R,g\u000e^*feZL7-\u001a\u0006\u0003\u001b9\tqa]3sm&\u001cWM\u0003\u0002\u0010!\u00051\u0001\u000f\\;hS:T!!\u0005\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011\u0001D\u0005\u0003C1\u0011AcU1na2,7i\u001c8uK:$8+\u001a:wS\u000e,\u0017!\u0003=mI\u000e{gNZ5h!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0004d_:4\u0017n\u001a\u0006\u0003QA\tAaY8sK&\u0011!&\n\u0002\n12$7i\u001c8gS\u001e\f\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f!\ti\u0003'D\u0001/\u0015\ty\u0003#\u0001\u0006sKB|7/\u001b;pefL!!\r\u0018\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-\u0001\rtC6\u0004H.Z\"p]R,g\u000e\u001e+sC:\u001chm\u001c:nKJ\u0004\"a\b\u001b\n\u0005Ub!\u0001G*b[BdWmQ8oi\u0016tG\u000f\u0016:b]N4wN]7fe\u00061A(\u001b8jiz\"B\u0001O\u001d;wA\u0011q\u0004\u0001\u0005\u0006E\u0011\u0001\ra\t\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006e\u0011\u0001\raM\u0001\u000fSN4\u0015\u000e\\3U_>d\u0015M]4f)\tq\u0014\t\u0005\u0002\u001a\u007f%\u0011\u0001I\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011U\u00011\u0001D\u0003\tI7\u000f\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006\u0011\u0011n\u001c\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUIA\u0006J]B,Ho\u0015;sK\u0006l\u0017\u0001\u0005;sC:\u001chm\u001c:n\u0007>tG/\u001a8u)\riek\u0019\u000b\u0003\u001dF\u0003\"aH(\n\u0005Ac!!D*b[BdWmQ8oi\u0016tG\u000fC\u0003S\r\u0001\u000f1+\u0001\u0004g_Jl\u0017\r\u001e\t\u0003?QK!!\u0016\u0007\u0003)M+\b\u000f]8si\u0016$7i\u001c8uK:$H+\u001f9f\u0011\u00159f\u00011\u0001Y\u0003\u0011\u0019\u0017.\u00133\u0011\u0005e\u0003gB\u0001._!\tY&$D\u0001]\u0015\tif#\u0001\u0004=e>|GOP\u0005\u0003?j\ta\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011qL\u0007\u0005\u0006\u0005\u001a\u0001\raQ\u0001$m\u0006d\u0017\u000eZ1uK\u0006sG\r\u0016:b]N4wN]7BeRLg-Y2u\u0007>tG/\u001a8u)\rqeM\u001d\u0005\u0006O\u001e\u0001\r\u0001[\u0001\tCJ$\u0018NZ1diB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\u0005E\u0006\u001cXM\u0003\u0002n]\u0006\u0019Q\u000fZ7\u000b\u0005=t\u0011aA1qS&\u0011\u0011O\u001b\u0002\u0017\u0005\u0006\u001cX\rR3qY>L\u0018M\u00197f\u0003J$\u0018NZ1di\")qk\u0002a\u00011\u0006Ar-\u001a;BeRLg-Y2u\u0007>tG/\u001a8u\u0005f\u001c\u0015.\u00133\u0015\u00059+\b\"B,\t\u0001\u0004A\u0016A\b;sC:\u001chm\u001c:n\u0007V\u001cHo\\7D_:$XM\u001c;SKN\u0004xN\\:f)\tA8\u0010\u0006\u0002Os\")!0\u0003a\u0002'\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u0015a\u0018\u00021\u0001D\u0003\u0019\u0019\u0018-\u001c9mK\u0006\tc/\u00197jI\u0006$X-\u00118e)J\fgn\u001d4pe6\u001cUo\u001d;p[\u000e{g\u000e^3oiR\u0019q0a\u0001\u0015\u00079\u000b\t\u0001C\u0003S\u0015\u0001\u000f1\u000b\u0003\u0004\u0002\u0006)\u0001\raQ\u0001\bG>tG/\u001a8uQ\r\u0001\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t#\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003'\t)\"A\u0004gC\u000e$xN]=\u000b\t\u0005]\u0011\u0011D\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u00037\ti\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty\"A\u0002pe\u001eLA!a\t\u0002\u000e\tI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0004\u0001\u0005\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\t\u00055\u0012\u0011D\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0019\u0003W\u0011qaU3sm&\u001cW\r")
public class DefaultSampleContentService
implements SampleContentService {
    private final XldConfig xldConfig;
    private final RepositoryService repositoryService;
    private final SampleContentTransformer sampleContentTransformer;

    private boolean isFileTooLarge(InputStream is) {
        int fileSizeLimit = this.xldConfig.patchDictionaries().maxFileSizeMb() * 1024 * 1024;
        return is.available() > fileSizeLimit;
    }

    private SampleContent transformContent(String ciId, InputStream is, SupportedContentType format) {
        SampleContent content;
        Try<SampleContent> try_ = this.sampleContentTransformer.transform(is, format);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new DataProcessingException(ciId, exception);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SampleContent sampleContent = content = (SampleContent)success.value();
        return sampleContent;
    }

    private SampleContent validateAndTransformArtifactContent(BaseDeployableArtifact artifact, String ciId) {
        InputStream is;
        Option option;
        block7: {
            Tuple2 tuple2;
            block6: {
                InputStream is2;
                Some some;
                String ext;
                Option option2;
                Option option3;
                InputStream inputStream;
                List formats = this.xldConfig.patchDictionaries().allowedFormats();
                Option extOption = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(artifact.getFile().getName())).split('.'))).tail())).lastOption();
                tuple2 = new Tuple2((Object)extOption, (Object)(inputStream = artifact.getFile().getInputStream()));
                if (tuple2 != null && None$.MODULE$.equals(option3 = (Option)tuple2._1())) {
                    throw new UnsupportedFileTypeException(ciId);
                }
                if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some && !formats.contains((Object)(ext = (String)(some = (Some)option2).value()))) {
                    throw new UnsupportedFileTypeException(ciId);
                }
                if (tuple2 != null && this.isFileTooLarge(is2 = (InputStream)tuple2._2())) {
                    throw new FileIsTooLargeException(ciId);
                }
                if (tuple2 == null) break block6;
                option = (Option)tuple2._1();
                is = (InputStream)tuple2._2();
                if (option instanceof Some) break block7;
            }
            throw new MatchError((Object)tuple2);
        }
        Some some = (Some)option;
        String ext = (String)some.value();
        SampleContent sampleContent = this.transformContent(ciId, is, SupportedContentType$.MODULE$.forExt(ext));
        return sampleContent;
    }

    @Override
    public SampleContent getArtifactContentByCiId(String ciId) {
        ConfigurationItem configurationItem = this.repositoryService.read(ciId, 1);
        ConfigurationItem configurationItem2 = configurationItem;
        if (!(configurationItem2 instanceof BaseDeployableArtifact)) {
            throw new WrongCITypeException(ciId);
        }
        BaseDeployableArtifact baseDeployableArtifact = (BaseDeployableArtifact)configurationItem2;
        SampleContent sampleContent = this.validateAndTransformArtifactContent(baseDeployableArtifact, ciId);
        return sampleContent;
    }

    private SampleContent transformCustomContentResponse(InputStream sample, SupportedContentType contentType) {
        SampleContent content;
        Try<SampleContent> try_ = this.sampleContentTransformer.transform(sample, contentType);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContentParsingException(exception);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SampleContent sampleContent = content = (SampleContent)success.value();
        return sampleContent;
    }

    @Override
    public SampleContent validateAndTransformCustomContent(InputStream content, SupportedContentType format) {
        if (this.isFileTooLarge(content)) {
            throw new ContentTooLargeException(this.xldConfig.patchDictionaries().maxFileSizeMb());
        }
        return this.transformCustomContentResponse(content, format);
    }

    public DefaultSampleContentService(XldConfig xldConfig, RepositoryService repositoryService, SampleContentTransformer sampleContentTransformer) {
        this.xldConfig = xldConfig;
        this.repositoryService = repositoryService;
        this.sampleContentTransformer = sampleContentTransformer;
    }
}

