/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.service.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.plugin.service.json.JsonSnippetService;
import com.xebialabs.deployit.plugin.service.json.PathNotFoundException;
import com.xebialabs.deployit.plugin.service.json.PositionByPathFinder;
import com.xebialabs.deployit.plugin.service.json.SnippetByPositionFinder;
import java.io.InputStream;
import org.springframework.stereotype.Component;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\u0004\b\u0001QAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\n\rBQA\u0016\u0001\u0005\u0002]CQ!\u001c\u0001\u0005B9DQ\u0001\u001e\u0001\u0005\nU\u0014QCS1dWN|gn\u00158jaB,GoU3sm&\u001cWM\u0003\u0002\t\u0013\u0005!!n]8o\u0015\tQ1\"A\u0004tKJ4\u0018nY3\u000b\u00051i\u0011A\u00029mk\u001eLgN\u0003\u0002\u000f\u001f\u0005AA-\u001a9m_fLGO\u0003\u0002\u0011#\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002%\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\b\u0013\tqrA\u0001\nKg>t7K\\5qa\u0016$8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0001\"!\ta\u0002!A\bt]&\u0004\b/\u001a;U_N#(/\u001b8h)\t!\u0013\u000bF\u0002&aq\u0002\"AJ\u0017\u000f\u0005\u001dZ\u0003C\u0001\u0015\u0018\u001b\u0005I#B\u0001\u0016\u0014\u0003\u0019a$o\\8u}%\u0011AfF\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-/!)\u0011G\u0001a\u0002e\u00051Q.\u00199qKJ\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0011\u0011\fG/\u00192j]\u0012T!a\u000e\u001d\u0002\u000f)\f7m[:p]*\u0011\u0011(E\u0001\nM\u0006\u001cH/\u001a:y[2L!a\u000f\u001b\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\t\u000bu\u0012\u00019\u0001 \u0002\u0011M$(/\u0019;fOf\u0004\"a\u0010(\u000f\u0005\u0001ceBA!L\u001d\t\u0011%J\u0004\u0002D\u0013:\u0011A\t\u0013\b\u0003\u000b\u001es!\u0001\u000b$\n\u0003II!\u0001E\t\n\u00059y\u0011B\u0001\u0007\u000e\u0013\tQ1\"\u0003\u0002\t\u0013%\u0011QjB\u0001\u0013\u0015N|gn\u00158jaB,GoU3sm&\u001cW-\u0003\u0002P!\n12K\\5qa\u0016$8+\u001a:wS\u000e,7\u000b\u001e:bi\u0016<\u0017P\u0003\u0002N\u000f!)!K\u0001a\u0001'\u0006!an\u001c3f!\t\u0019D+\u0003\u0002Vi\tA!j]8o\u001d>$W-\u0001\u0006hKR\u001cf.\u001b9qKR$2\u0001\u00170i)\rIF,\u0018\t\u0003\u007fiK!a\u0017)\u0003\u000fMs\u0017\u000e\u001d9fi\")\u0011g\u0001a\u0002e!)Qh\u0001a\u0002}!)ql\u0001a\u0001A\u000691m\u001c8uK:$\bCA1g\u001b\u0005\u0011'BA2e\u0003\tIwNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'aC%oaV$8\u000b\u001e:fC6DQ![\u0002A\u0002)\fA\u0001\\5oKB\u0011ac[\u0005\u0003Y^\u00111!\u00138u\u0003-9W\r\u001e)bi\"d\u0015N\\3\u0015\u0007=\f(\u000f\u0006\u0002ka\")\u0011\u0007\u0002a\u0002e!)q\f\u0002a\u0001A\")1\u000f\u0002a\u0001K\u0005!\u0001/\u0019;i\u0003!1\u0017N\u001c3CKN$HC\u0001<|)\t9(\u0010\u0005\u0002@q&\u0011\u0011\u0010\u0015\u0002\u000f':L\u0007\u000f]3u!>Lg\u000e^3s\u0011\u0015iT\u0001q\u0001?\u0011\u0015aX\u00011\u0001~\u0003!\u0019h.\u001b9qKR\u001c\b\u0003\u0002@\u0002\b]t1a`A\u0002\u001d\rA\u0013\u0011A\u0005\u00021%\u0019\u0011QA\f\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000b9\u0002f\u0001\u0001\u0002\u0010A!\u0011\u0011CA\u0010\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AC:uKJ,w\u000e^=qK*!\u0011\u0011DA\u000e\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\t\u0019BA\u0005D_6\u0004xN\\3oi\u0002")
public class JacksonSnippetService
implements JsonSnippetService {
    private String snippetToString(JsonNode node, ObjectMapper mapper, JsonSnippetService.SnippetServiceStrategy strategy) {
        String result = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        return strategy.postProcessSnippet(result, node);
    }

    @Override
    public JsonSnippetService.Snippet getSnippet(InputStream content, int line, ObjectMapper mapper, JsonSnippetService.SnippetServiceStrategy strategy) {
        JsonParser parser = mapper.getFactory().createParser(content);
        SnippetByPositionFinder wrapped = new SnippetByPositionFinder(parser, line);
        JsonNode tree = (JsonNode)mapper.readTree((JsonParser)wrapped);
        JsonSnippetService.SnippetPointer snippet = this.findBest((Seq<JsonSnippetService.SnippetPointer>)wrapped.snippets(), strategy);
        JsonNode node = tree.at(snippet.pointer().toString());
        return new JsonSnippetService.Snippet(snippet.pointer().toString(), this.snippetToString(node, mapper, strategy));
    }

    @Override
    public int getPathLine(InputStream content, String path, ObjectMapper mapper) {
        JsonPointer pointer = JsonPointer.valueOf((String)path);
        JsonParser parser = mapper.getFactory().createParser(content);
        PositionByPathFinder wrapped = new PositionByPathFinder(parser, pointer);
        mapper.readTree((JsonParser)wrapped);
        List list = wrapped.pathLines().toList();
        if (Nil$.MODULE$.equals(list)) {
            throw new PathNotFoundException(path);
        }
        if (!(list instanceof .colon.colon)) {
            throw new MatchError((Object)list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        JsonSnippetService.LinePointer head = (JsonSnippetService.LinePointer)colon2.head();
        int n = head.position();
        return n;
    }

    private JsonSnippetService.SnippetPointer findBest(Seq<JsonSnippetService.SnippetPointer> snippets, JsonSnippetService.SnippetServiceStrategy strategy) {
        if (snippets.isEmpty()) {
            throw new IllegalArgumentException("Line not found.");
        }
        return (JsonSnippetService.SnippetPointer)snippets.max(strategy.pointerOrdering());
    }
}

