package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.support.application.ApplicationWithPackages
import com.xebialabs.xltype.serialization.json.JsonWriter
import com.xebialabs.xltype.serialization.rest.TypeMatcher
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{Collection => JCollection}
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.Provider

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ApplicationWithPackagesJsonWriter extends AbstractJsonWriter[JCollection[ApplicationWithPackages]] {

  private val matcher = new TypeMatcher(classOf[JCollection[_]], classOf[ApplicationWithPackages])
  private val applicationWithPackagesLineJsonWriter = new ApplicationWithPackagesLineJsonWriter

  override def isWriteable(typeClass: Class[_], genericType: Type, annotations: Array[Annotation], mediaType: MediaType): Boolean =
    matcher.matches(typeClass, genericType)

  override def writeTo(applicationWithPackages: JCollection[ApplicationWithPackages], typeClass: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit =
    entityStream.write(toJson(applicationWithPackages).getBytes)


  override protected def writeJson(lines: JCollection[ApplicationWithPackages], writer: JsonWriter): Unit = {
    writer.array
    lines.forEach { line =>
      applicationWithPackagesLineJsonWriter.writeJson(line, writer)
    }
    writer.endArray
  }
}
