/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.support.report;

import ai.digital.deploy.metrics.model.CiCount;
import ai.digital.deploy.metrics.repository.CiMetricsRepository;
import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.api.TaskMonitorService;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepository;
import com.xebialabs.deployit.support.report.CiStatistics;
import com.xebialabs.deployit.support.report.ControlTaskStatistics;
import com.xebialabs.deployit.support.report.DataStatisticsRepositoryService;
import com.xebialabs.deployit.support.report.DeploymentStatistics;
import com.xebialabs.deployit.support.report.FolderStatistics;
import com.xebialabs.deployit.support.report.PlaceholderStatistics;
import com.xebialabs.deployit.support.report.UserAndRoleStatistics;
import com.xebialabs.deployit.support.report.report$;
import com.xebialabs.xlplatform.support.report.ReportDataProvider;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005G\u0001\t\u0005\t\u0015!\u00039\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00069\u0002!\t!\u0018\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0011\u0019y\b\u0001)A\u0005i\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u00111\r\u0001\u0005\u0002\u0005\u0015$A\u0006#bi\u0006\u001cF/\u0019;jgRL7m\u001d)s_ZLG-\u001a:\u000b\u0005Y9\u0012A\u0002:fa>\u0014HO\u0003\u0002\u00193\u000591/\u001e9q_J$(B\u0001\u000e\u001c\u0003!!W\r\u001d7ps&$(B\u0001\u000f\u001e\u0003%AXMY5bY\u0006\u00147OC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!jS\"A\u0015\u000b\u0005YQ#B\u0001\r,\u0015\ta3$\u0001\u0006yYBd\u0017\r\u001e4pe6L!AL\u0015\u0003%I+\u0007o\u001c:u\t\u0006$\u0018\r\u0015:pm&$WM]\u0001\u0019I\u0006$\u0018m\u0015;bi&\u001cH/[2t%\u0016\u0004xn]5u_JLX#A\u0019\u0011\u0005I\u001aT\"A\u000b\n\u0005Q*\"a\b#bi\u0006\u001cF/\u0019;jgRL7m\u001d*fa>\u001c\u0018\u000e^8ssN+'O^5dK\u0006IB-\u0019;b'R\fG/[:uS\u000e\u001c(+\u001a9pg&$xN]=!\u0003M\u0019\u0017.T3ue&\u001c7OU3q_NLGo\u001c:z+\u0005A\u0004CA\u001dE\u001b\u0005Q$BA\u001e=\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003{y\nq!\\3ue&\u001c7O\u0003\u0002@\u0001\u00061A-\u001a9m_fT!!\u0011\"\u0002\u000f\u0011Lw-\u001b;bY*\t1)\u0001\u0002bS&\u0011QI\u000f\u0002\u0014\u0007&lU\r\u001e:jGN\u0014V\r]8tSR|'/_\u0001\u0015G&lU\r\u001e:jGN\u0014V\r]8tSR|'/\u001f\u0011\u0002+Ad\u0017mY3i_2$WM\u001d*fa>\u001c\u0018\u000e^8ssV\t\u0011\n\u0005\u0002K\u001d6\t1J\u0003\u0002M\u001b\u0006a\u0001\u000f\\1dK\"|G\u000eZ3sg*\u00111(G\u0005\u0003\u001f.\u0013Q\u0003\u00157bG\u0016Dw\u000e\u001c3feJ+\u0007o\\:ji>\u0014\u00180\u0001\fqY\u0006\u001cW\r[8mI\u0016\u0014(+\u001a9pg&$xN]=!\u0003I!\u0018m]6N_:LGo\u001c:TKJ4\u0018nY3\u0016\u0003M\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\u0007\u0005\u0004\u0018N\u0003\u0002Y3\u0005!1m\u001c:f\u0013\tQVK\u0001\nUCN\\Wj\u001c8ji>\u00148+\u001a:wS\u000e,\u0017a\u0005;bg.luN\\5u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003_?\u0002\f'\r\u0005\u00023\u0001!)q&\u0003a\u0001c!)a'\u0003a\u0001q!)q)\u0003a\u0001\u0013\")\u0011+\u0003a\u0001'\"\u0012\u0011\u0002\u001a\t\u0003KBl\u0011A\u001a\u0006\u0003O\"\f!\"\u00198o_R\fG/[8o\u0015\tI'.A\u0004gC\u000e$xN]=\u000b\u0005-d\u0017!\u00022fC:\u001c(BA7o\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A8\u0002\u0007=\u0014x-\u0003\u0002rM\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0005]\u0006lW-F\u0001u!\t)HP\u0004\u0002wuB\u0011qoI\u0007\u0002q*\u0011\u0011pH\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a_\u0012\u0002\u000b9\fW.\u001a\u0011\u0002#\r|G\u000e\\3diN#\u0018\r^5ti&\u001c7/\u0006\u0002\u0002\u0006A1Q/a\u0002u\u0003\u0017I1!!\u0003\u007f\u0005\ri\u0015\r\u001d\t\u0004E\u00055\u0011bAA\bG\t\u0019\u0011I\\=\u0002'\r|G\u000e\\3di\u000eK7\u000b^1uSN$\u0018nY:\u0016\u0005\u0005U\u0001c\u0001\u001a\u0002\u0018%\u0019\u0011\u0011D\u000b\u0003\u0019\rK7\u000b^1uSN$\u0018nY:\u00027\r|G\u000e\\3di\u0012+\u0007\u000f\\8z[\u0016tGo\u0015;bi&\u001cH/[2t+\t\ty\u0002E\u00023\u0003CI1!a\t\u0016\u0005Q!U\r\u001d7ps6,g\u000e^*uCRL7\u000f^5dg\u0006\u0011r-\u001a;EKBdw._7f]R\u001cu.\u001e8u)\u0019\tI#a\f\u0002BA\u0019!%a\u000b\n\u0007\u000552EA\u0002J]RDaAF\bA\u0002\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003wq\u0014aA:rY&!\u0011qHA\u001b\u0005\u0019\u0011V\r]8si\"1\u00111I\bA\u0002Q\fa\u0002Z3qY>LX.\u001a8u)f\u0004X-A\fd_2dWm\u0019;G_2$WM]*uCRL7\u000f^5dgV\u0011\u0011\u0011\n\t\u0004e\u0005-\u0013bAA'+\t\u0001bi\u001c7eKJ\u001cF/\u0019;jgRL7m]\u0001\"G>dG.Z2u\u0007>tGO]8m)\u0006\u001c8.V:bO\u0016\u001cF/\u0019;jgRL7m]\u000b\u0003\u0003'\u00022AMA+\u0013\r\t9&\u0006\u0002\u0016\u0007>tGO]8m)\u0006\u001c8n\u0015;bi&\u001cH/[2t\u0003u\u0019w\u000e\u001c7fGR,6/\u001a:t\u0003:$'k\u001c7f'R\fG/[:uS\u000e\u001cXCAA/!\r\u0011\u0014qL\u0005\u0004\u0003C*\"!F+tKJ\fe\u000e\u001a*pY\u0016\u001cF/\u0019;jgRL7m]\u0001\u001dG>dG.Z2u!2\f7-\u001a5pY\u0012,'o\u0015;bi&\u001cH/[2t+\t\t9\u0007E\u00023\u0003SJ1!a\u001b\u0016\u0005U\u0001F.Y2fQ>dG-\u001a:Ti\u0006$\u0018n\u001d;jGND3\u0001AA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;Y\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00141\u000f\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DataStatisticsProvider
implements ReportDataProvider {
    private final DataStatisticsRepositoryService dataStatisticsRepository;
    private final CiMetricsRepository ciMetricsRepository;
    private final PlaceholderRepository placeholderRepository;
    private final TaskMonitorService taskMonitorService;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DataStatisticsProvider dataStatisticsProvider = this;
        synchronized (dataStatisticsProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public DataStatisticsRepositoryService dataStatisticsRepository() {
        return this.dataStatisticsRepository;
    }

    public CiMetricsRepository ciMetricsRepository() {
        return this.ciMetricsRepository;
    }

    public PlaceholderRepository placeholderRepository() {
        return this.placeholderRepository;
    }

    public TaskMonitorService taskMonitorService() {
        return this.taskMonitorService;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> collectStatistics() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ci"), (Object)this.collectCiStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployments"), (Object)this.collectDeploymentStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks"), (Object)this.collectControlTaskUsageStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"folders"), (Object)this.collectFolderStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)this.collectUsersAndRoleStatistics()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"placeholders"), (Object)this.collectPlaceholderStatistics())}))).asJava())}));
    }

    public CiStatistics collectCiStatistics() {
        CiStatistics statistics = new CiStatistics();
        CiCount applicationCount = this.ciMetricsRepository().getCisCount((List)new .colon.colon((Object)"udm.Application", (List)Nil$.MODULE$), (Option)new Some((Object)"/Applications"), null, null, null);
        statistics.totalApplication_$eq((int)applicationCount.ciCount());
        statistics.totalHosts_$eq(this.dataStatisticsRepository().hostCount());
        statistics.totalSatellites_$eq(this.dataStatisticsRepository().satelliteCount());
        statistics.totalWorker_$eq(this.dataStatisticsRepository().workersCount());
        return statistics;
    }

    public DeploymentStatistics collectDeploymentStatistics() {
        DeploymentStatistics statistics = new DeploymentStatistics();
        Date fromDate = new Date(DateTime.now().minusDays(30).toDate().toString());
        Date toDate = new Date(DateTime.now().toDate().toString());
        Date from24hrs = new Date(DateTime.now().minusHours(24).toDate().toString());
        Report reportFor24hrs = this.dataStatisticsRepository().getDeploymentReportForAPeriod(from24hrs, toDate);
        statistics.successfulDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "successful"));
        statistics.rollbackDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "rollback"));
        statistics.abortedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "aborted"));
        statistics.retriedDeploymentsIn24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "failed"));
        statistics.totalDeploymentFor24hrs_$eq(this.getDeploymentCount(reportFor24hrs, "totalDeployment"));
        Report reportFor30days = this.dataStatisticsRepository().getDeploymentReportForAPeriod(fromDate, toDate);
        statistics.totalDeploymentFor30days_$eq(this.getDeploymentCount(reportFor30days, "totalDeployment"));
        statistics.averageDeploymentPerDayPerMonth_$eq(report$.MODULE$.avg(statistics.totalDeploymentFor30days(), 30));
        Date forAYear = new Date(DateTime.now().minusDays(365).toDate().toString());
        Report reportForAYear = this.dataStatisticsRepository().getDeploymentReportForAPeriod(forAYear, toDate);
        int totalDeploymentForYr = this.getDeploymentCount(reportForAYear, "totalDeployment");
        statistics.averageDeploymentPerDayPerYr_$eq(report$.MODULE$.avg(totalDeploymentForYr, 365));
        statistics.totalDeploymentsInLastYear_$eq(totalDeploymentForYr);
        statistics.successfulDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "successful"));
        statistics.rollbackDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "rollback"));
        statistics.abortedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "aborted"));
        statistics.retriedDeploymentsInLastYear_$eq(this.getDeploymentCount(reportForAYear, "failed"));
        statistics.totalPendingDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, true, true, true));
        statistics.totalScheduledDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", true, false, false, false));
        statistics.totalQueuedDeployment_$eq(this.dataStatisticsRepository().pendingTaskCount("deployment", false, false, true, false));
        statistics.activeDeployments_$eq(this.dataStatisticsRepository().activeTaskCount("deployment"));
        return statistics;
    }

    public int getDeploymentCount(Report report2, String deploymentType) {
        int successful = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfSuccessfulDeployments").toString()));
        int rollBack = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfRollbacks").toString()));
        int failed = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfFailedDeployments").toString()));
        int aborted = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(((ReportLine)report2.getLines().get(0)).getValues().get("noOfAbortedDeployments").toString()));
        int totalDeployment = successful + rollBack + failed + aborted;
        String string = deploymentType;
        switch (string == null ? 0 : string.hashCode()) {
            case -1281977283: {
                if (!"failed".equals(string)) break;
                return failed;
            }
            case -1194777649: {
                if (!"aborted".equals(string)) break;
                return aborted;
            }
            case -733631846: {
                if (!"successful".equals(string)) break;
                return successful;
            }
            case -259719452: {
                if (!"rollback".equals(string)) break;
                return rollBack;
            }
            case 1596796201: {
                if (!"totalDeployment".equals(string)) break;
                return totalDeployment;
            }
        }
        throw new MatchError((Object)string);
    }

    public FolderStatistics collectFolderStatistics() {
        FolderStatistics statistics = new FolderStatistics();
        statistics.applicationFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Applications")).foldersCount());
        statistics.environmentFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Environments")).foldersCount());
        statistics.infraFolderCount_$eq((int)this.ciMetricsRepository().getSubFoldersCount((Option)new Some((Object)"/Infrastructure")).foldersCount());
        return statistics;
    }

    public ControlTaskStatistics collectControlTaskUsageStatistics() {
        ControlTaskStatistics controlTaskStatistics = new ControlTaskStatistics();
        int totalTasksFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalTaskFor24hrs(totalTasksFor24Hours);
        int totalTasksFor30Days = this.dataStatisticsRepository().archivedControlTaskCount(null, DateTime.now().minusDays(30), DateTime.now());
        controlTaskStatistics.setTotalTaskFor30days(totalTasksFor30Days);
        controlTaskStatistics.setAverageTaskPerDayPerMonth(report$.MODULE$.avg(totalTasksFor30Days, 30));
        int totalTasksPerYear = this.dataStatisticsRepository().archivedControlTaskCount("ALL", DateTime.now().minusDays(365), DateTime.now());
        controlTaskStatistics.setAverageTaskPerDayPerYr(report$.MODULE$.avg(totalTasksPerYear, 365));
        int totalActiveTasks = this.dataStatisticsRepository().activeTaskCount("Control task");
        controlTaskStatistics.setTotalActiveTasks(totalActiveTasks);
        int pendingCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, true, true, true);
        controlTaskStatistics.setTotalPendingTasks(pendingCount);
        int scheduledCount = this.dataStatisticsRepository().pendingTaskCount("Control task", true, false, false, false);
        controlTaskStatistics.setTotalScheduledTasks(scheduledCount);
        int queuedCount = this.dataStatisticsRepository().pendingTaskCount("Control task", false, false, true, false);
        controlTaskStatistics.setTotalQueuedTasks(queuedCount);
        int completedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.DONE.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalSuccessfulTasksIn24Hours(completedCountFor24Hours);
        int abortedCountFor24Hours = this.dataStatisticsRepository().archivedControlTaskCount(TaskExecutionState.CANCELLED.name(), DateTime.now().minusDays(1), DateTime.now());
        controlTaskStatistics.setTotalAbortedTasksIn24Hours(abortedCountFor24Hours);
        return controlTaskStatistics;
    }

    public UserAndRoleStatistics collectUsersAndRoleStatistics() {
        UserAndRoleStatistics statistics = new UserAndRoleStatistics();
        statistics.totalActiveUsers_$eq(this.dataStatisticsRepository().totalActiveUsersCount());
        statistics.totalGlobalRoles_$eq(this.dataStatisticsRepository().totalGlobalRoleCount());
        return statistics;
    }

    public PlaceholderStatistics collectPlaceholderStatistics() {
        PlaceholderStatistics statistics = new PlaceholderStatistics();
        statistics.placeholdersCount_$eq(this.dataStatisticsRepository().getAllPlaceholdersCount());
        statistics.avgPlaceholdersCountByDeployedApp_$eq(this.dataStatisticsRepository().getAvgPlaceholdersCount());
        statistics.appWithMaxPlaceholders_$eq(((IterableOnceOps)this.dataStatisticsRepository().getApplicationsWithMaxPlaceholders(5).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return k + " - " + Integer.toString(v);
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n"));
        return statistics;
    }

    @Autowired
    public DataStatisticsProvider(DataStatisticsRepositoryService dataStatisticsRepository, CiMetricsRepository ciMetricsRepository, PlaceholderRepository placeholderRepository, TaskMonitorService taskMonitorService) {
        this.dataStatisticsRepository = dataStatisticsRepository;
        this.ciMetricsRepository = ciMetricsRepository;
        this.placeholderRepository = placeholderRepository;
        this.taskMonitorService = taskMonitorService;
        Logging.$init$((Logging)this);
        this.name = "data";
    }
}

