/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.SatelliteConnectionState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.task.archive.ArchivedAbstractBlock;
import java.util.List;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;

public class ArchivedStepBlock
extends ArchivedAbstractBlock
implements StepBlockState {
    private String satelliteId;
    private List<StepState> steps = Lists.newArrayList();

    public int getCurrentStep() {
        return 0;
    }

    public List<StepState> getSteps() {
        return this.steps;
    }

    public String getSatelliteId() {
        return this.satelliteId;
    }

    public void setSatelliteId(String satelliteId) {
        this.satelliteId = satelliteId;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public List<StepState> getStepList() {
        return this.getSteps();
    }

    public StepState getStep(BlockPath path) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("No step information");
        }
        if (path.isLeaf()) {
            return this.steps.get(path.head() - 1);
        }
        throw new IllegalArgumentException("Leaf block but not leaf path");
    }

    public Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply((Object)this);
        }
        throw new IllegalArgumentException("Leaf block but not leaf path");
    }

    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        BlockPath id = this.id();
        ListBuffer buffer = new ListBuffer();
        for (int i = 0; i < this.steps.size(); ++i) {
            buffer.$plus$eq((Object)new Tuple2((Object)id.newSubPath(i + 1), (Object)this.steps.get(i)));
        }
        return buffer;
    }

    public SatelliteConnectionState satelliteState() {
        return super.getSatelliteConnectionState();
    }
}

