package com.xebialabs.deployit.plugin.test.yak.step;

import java.util.concurrent.CountDownLatch;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;

public class LatchStep implements DeploymentStep {
    private transient CountDownLatch countDownLatch;

    public LatchStep(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    @Override
    public String getDescription() {
        return "Waits until latch is triggered";
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
        try {
            countDownLatch.await();
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Step.Result.Success;
        }
        return Step.Result.Fail;  //To change body of implemented methods use File | Settings | File Templates.
    }

	@Override
	public int getOrder() {
		return 40;
	}
}
