package com.xebialabs.deployit.plugin.test.yak.ci;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.DeleteYakFileFromServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.DeployYakFileToServerStep;
import com.xebialabs.deployit.plugin.test.yak.step.FirstTimePauseStep;

public class DeployedDestroyCreateYakCheckpointFile extends BaseDeployed<YakCheckpointFile, YakServer> {

    @Create @Modify
    public void deploy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding deploy step");
        DeployYakFileToServerStep deployYakFileToServerStep = new DeployYakFileToServerStep();
        result.addStep(deployYakFileToServerStep);
        result.addCheckpoint(deployYakFileToServerStep, delta, Operation.CREATE);
        result.addStep(new FirstTimePauseStep(deployYakFileToServerStep.getOrder()));
    }

    @Destroy @Modify
    public void destroy(DeploymentPlanningContext result, Delta delta) {
        logger.info("Adding undeploy step");
        DeleteYakFileFromServerStep step = new DeleteYakFileFromServerStep();
        result.addStep(step);
        result.addCheckpoint(step, delta, Operation.DESTROY);
        result.addStep(new FirstTimePauseStep(step.getOrder()));
    }


    private static final Logger logger = LoggerFactory.getLogger(DeployedDestroyCreateYakCheckpointFile.class);
}
