package com.xebialabs.deployit.plugin.test.yak.ci;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.test.yak.step.FirstStep;

import static com.google.common.collect.Maps.newHashMap;

public class YakConfiguration extends BaseDeployed<YakConfigurationSpec, YakServer> {

    @SuppressWarnings("unused")
    @Property(required = false)
    private String yakName;

    @SuppressWarnings("unused")
    @Property(required = false)
    private Map<String, String> properties = newHashMap();

    @Create
    public void createSteps(DeploymentPlanningContext result) {
        result.addStep(new FirstStep());
    }

    @Destroy
    public void destroySteps(DeploymentPlanningContext result) {
        result.addStep(new FirstStep());
        result.addStep(new FirstStep());
    }

}
