package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

import java.util.concurrent.CountDownLatch;

@SuppressWarnings("serial")
public class LatchStep implements Step {
    private transient CountDownLatch countDownLatch;

    public LatchStep(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    @Override
    public String getDescription() {
        return "Waits until latch is triggered";
    }


    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            countDownLatch.await();
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.FAIL;
    }

    @Override
    public int getOrder() {
        return 40;
    }
}
