package com.xebialabs.gradle.defaults.tasks

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

class DumpVersion extends DefaultTask {

  DumpVersion() {
    this.mustRunAfter("clean")
  }

  @OutputFile
  File dumpFile

  @Input
  String version

  @TaskAction
  def dump() {
    logger.lifecycle("Dumping version ${getVersion()} to file.")
    if (!dumpFile.parentFile.isDirectory()) {
      dumpFile.parentFile.mkdirs()
    }
    // Use the getter to get the conventionMapping resolution going... Never forget!
    dumpFile.write("version=${getVersion()}\n")
  }
}
