/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.plugins.jira.oauth;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;

public class AtlassianOAuthClient {
    protected static final String SERVLET_BASE_URL = "/plugins/servlet";
    private final String consumerKey;
    private final String privateKey;
    private final String baseUrl;
    private final String callback;
    private OAuthAccessor accessor;

    public AtlassianOAuthClient(String consumerKey, String privateKey, String baseUrl, String callback) {
        this.consumerKey = consumerKey;
        this.privateKey = privateKey;
        this.baseUrl = baseUrl;
        this.callback = callback;
    }

    public TokenSecretVerifierHolder getRequestToken() {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new HttpClient4());
            ImmutableList callBack = this.callback == null || "".equals(this.callback) ? Collections.emptyList() : ImmutableList.of((Object)new OAuth.Parameter("oauth_callback", this.callback));
            OAuthMessage message = oAuthClient.getRequestTokenResponse(accessor, "POST", callBack);
            TokenSecretVerifierHolder tokenSecretVerifier = new TokenSecretVerifierHolder();
            tokenSecretVerifier.token = accessor.requestToken;
            tokenSecretVerifier.secret = accessor.tokenSecret;
            tokenSecretVerifier.verifier = message.getParameter("oauth_verifier");
            return tokenSecretVerifier;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain request token", e);
        }
    }

    public String swapRequestTokenForAccessToken(String requestToken, String tokenSecret, String oauthVerifier) {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
            accessor.requestToken = requestToken;
            accessor.tokenSecret = tokenSecret;
            OAuthMessage message = client.getAccessToken(accessor, "POST", (Collection)ImmutableList.of((Object)new OAuth.Parameter("oauth_verifier", oauthVerifier)));
            return message.getToken();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to swap request token with access token", e);
        }
    }

    public String makeAuthenticatedRequest(String url, String accessToken) {
        try {
            OAuthAccessor accessor = this.getAccessor();
            OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
            accessor.accessToken = accessToken;
            OAuthMessage response = client.invoke(accessor, url, Collections.emptySet());
            return response.readBodyAsString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to make an authenticated request.", e);
        }
    }

    private OAuthAccessor getAccessor() {
        if (this.accessor == null) {
            OAuthServiceProvider serviceProvider = new OAuthServiceProvider(this.getRequestTokenUrl(), this.getAuthorizeUrl(), this.getAccessTokenUrl());
            OAuthConsumer consumer = new OAuthConsumer(this.callback, this.consumerKey, null, serviceProvider);
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)this.privateKey);
            consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            this.accessor = new OAuthAccessor(consumer);
        }
        return this.accessor;
    }

    private String getAccessTokenUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/access-token";
    }

    private String getRequestTokenUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/request-token";
    }

    public String getAuthorizeUrlForToken(String token) {
        return this.getAuthorizeUrl() + "?oauth_token=" + token;
    }

    private String getAuthorizeUrl() {
        return this.baseUrl + SERVLET_BASE_URL + "/oauth/authorize";
    }

    public class TokenSecretVerifierHolder {
        public String token;
        public String verifier;
        public String secret;
    }
}

