/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.specs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public class BaseTest {
    protected static final String BROWSER = System.getProperty("BROWSER", "chrome");
    protected static final boolean REMOTE_DRIVER = Boolean.valueOf(System.getProperty("REMOTE_DRIVER", "false"));
    protected static final String SELENIUM_HOST = System.getProperty("SELENIUM_HOST", "localhost");
    protected static final int SELENIUM_PORT = Integer.valueOf(System.getProperty("SELENIUM_PORT", "4444"));
    protected static final boolean CHROME_HEADLESS_MODE = Boolean.valueOf(System.getProperty("CHROME_HEADLESS_MODE", "false"));
    protected static final boolean FIREFOX_HEADLESS_MODE = Boolean.valueOf(System.getProperty("FIREFOX_HEADLESS_MODE", "true"));
    public static final String WEB_SERVER = System.getProperty("WEB_SERVER", "http://localhost:5516");
    public static RemoteWebDriver driver;

    @BeforeSuite
    public void setupWebDriver() throws MalformedURLException {
        if (REMOTE_DRIVER) {
            this.setupRemoteDriver();
            driver.setFileDetector((FileDetector)new LocalFileDetector());
        } else {
            this.setupLocalDriver();
        }
        driver.manage().timeouts().implicitlyWait(20L, TimeUnit.SECONDS);
        driver.manage().window().maximize();
    }

    private void setupLocalDriver() {
        if (BROWSER.equals("firefox")) {
            System.setProperty("webdriver.gecko.driver", this.copyDriver("geckodriver"));
            FirefoxBinary firefoxBinary = new FirefoxBinary();
            if (FIREFOX_HEADLESS_MODE) {
                firefoxBinary.addCommandLineOptions(new String[]{"--headless"});
            }
            FirefoxOptions firefoxOptions = new FirefoxOptions();
            firefoxOptions.setBinary(firefoxBinary);
            driver = new FirefoxDriver(firefoxOptions);
            driver.get(WEB_SERVER);
        } else if (BROWSER.equals("chrome")) {
            System.setProperty("webdriver.chrome.driver", this.copyDriver("chromedriver"));
            ChromeOptions options = new ChromeOptions();
            options.setHeadless(CHROME_HEADLESS_MODE);
            options.addArguments(new String[]{"--window-size=1280,800"});
            driver = new ChromeDriver(options);
            driver.get(WEB_SERVER);
        } else {
            throw new RuntimeException("Browser type unsupported");
        }
    }

    private String copyDriver(String driverName) {
        String OS = this.getOSName();
        String tempDir = System.getProperty("java.io.tmpdir");
        Path resolve = Paths.get(tempDir, new String[0]).resolve(driverName + OS);
        if (!resolve.toFile().exists()) {
            try (InputStream stream = this.getClass().getResourceAsStream("/drivers/" + driverName + OS);){
                Files.copy(stream, resolve, new CopyOption[0]);
                File file = resolve.toFile();
                file.setExecutable(true);
                file.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return resolve.toString();
    }

    private String getOSName() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            OS = ".exe";
        } else if (OS.indexOf("mac") >= 0) {
            OS = "-mac";
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0 || OS.indexOf("sunos") >= 0) {
            OS = "-linux";
        } else {
            throw new RuntimeException("OS type unsupported");
        }
        return OS;
    }

    private void setupRemoteDriver() throws MalformedURLException {
        DesiredCapabilities capabilities;
        if (BROWSER.equals("firefox")) {
            capabilities = DesiredCapabilities.firefox();
        } else if (BROWSER.equals("internetExplorer")) {
            capabilities = DesiredCapabilities.internetExplorer();
            capabilities.setCapability("ignoreProtectedModeSettings", true);
        } else if (BROWSER.equals("chrome")) {
            capabilities = DesiredCapabilities.chrome();
        } else {
            throw new RuntimeException("Browser type unsupported");
        }
        driver = new RemoteWebDriver(new URL("http://" + SELENIUM_HOST + ":" + SELENIUM_PORT + "/wd/hub"), (Capabilities)capabilities);
        driver.get(WEB_SERVER);
    }

    @AfterSuite
    public void suiteTearDown() {
        driver.manage().deleteAllCookies();
        driver.quit();
    }
}

