/*
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.gradle.plugins.xlrelease

import com.xebialabs.gradle.plugins.XLPluginBundlePlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * The main plugin to use in a XL Release plugin project. It combines several dependent plugins.
 */
class XlReleasePluginPlugin implements Plugin<Project> {

  @Override
  void apply(final Project project) {
    project.plugins.apply(XLPluginBundlePlugin)
    project.plugins.apply(XlReleaseInstancePlugin)
    project.plugins.apply(XlReleaseDependenciesPlugin)
  }
}
