/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.itest;

import com.google.common.base.Preconditions;
import com.xebialabs.itest.ItestHost;
import com.xebialabs.itest.ItestHostFactory;
import com.xebialabs.itest.LaxKeyVerifier;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;

class TunneledItestHost
implements ItestHost {
    private final ItestHost actualItestHost;
    private final String tunnelUsername;
    private final String tunnelPassword;
    private final Map<Integer, Integer> portForwardMap;
    private SSHClient client;

    TunneledItestHost(ItestHost actualItestHost, String tunnelUsername, String tunnelPassword, Map<Integer, Integer> portForwardMap) {
        this.actualItestHost = actualItestHost;
        this.tunnelUsername = tunnelUsername;
        this.tunnelPassword = tunnelPassword;
        this.portForwardMap = portForwardMap;
    }

    @Override
    public void setup() {
        this.actualItestHost.setup();
        this.client = new SSHClient();
        this.client.addHostKeyVerifier((HostKeyVerifier)new LaxKeyVerifier());
        try {
            this.client.connect(this.actualItestHost.getHostName(), 22);
            this.client.authPassword(this.tunnelUsername, this.tunnelPassword);
            for (Map.Entry<Integer, Integer> forwardedPort : this.portForwardMap.entrySet()) {
                int remotePort = forwardedPort.getKey();
                int localPort = forwardedPort.getValue();
                final LocalPortForwarder forwarder = this.client.newLocalPortForwarder((SocketAddress)new InetSocketAddress("localhost", localPort), "localhost", remotePort);
                Thread forwarderThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            forwarder.listen();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, "SSH port forwarder thread from local port " + localPort + " to " + this.actualItestHost.getHostName() + ":" + remotePort);
                forwarderThread.setDaemon(true);
                ItestHostFactory.logger.info("Starting {}", (Object)forwarderThread.getName());
                forwarderThread.start();
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot set up tunnels to " + this.actualItestHost.getHostName(), exc);
        }
    }

    @Override
    public void teardown() {
        try {
            this.client.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.actualItestHost.teardown();
    }

    @Override
    public String getHostName() {
        return "localhost";
    }

    @Override
    public int getPort(int port) {
        Preconditions.checkArgument((boolean)this.portForwardMap.containsKey(port), (Object)("Port " + port + " is not tunneled"));
        return this.portForwardMap.get(port);
    }
}

