/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.rest.doclet.FileCatalog;
import com.xebialabs.rest.doclet.RestDoclet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RestdocWriter
extends HtmlWriter {
    public RestdocWriter(PrintWriter writer) {
        super(writer);
    }

    protected String asText(Tag[] tags) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                this.appendLink(builder, (SeeTag)tag);
                continue;
            }
            builder.append(tag.text());
        }
        return builder.toString();
    }

    private void appendLink(StringBuilder builder, SeeTag tag) {
        String text;
        String file = RestDoclet.fileNameFor((Type)tag.referencedClass());
        String string = text = tag.label() != null ? tag.label() : tag.text();
        if (file != null && FileCatalog.SINGLETON.check(file)) {
            builder.append(this.link(file, new Object[]{text}));
        } else {
            builder.append(this.bold(new Object[]{text}));
        }
    }

    protected String asText(Type type) {
        return RestdocWriter.asText(type, " of ", ", ", "");
    }

    private static String asText(Type type, String separator1, String separator2, String end) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.simpleTypeName());
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            builder.append(separator1);
            for (int i = 0; i < paramType.typeArguments().length; ++i) {
                Type param = paramType.typeArguments()[i];
                builder.append(param.simpleTypeName());
                if (i >= paramType.typeArguments().length - 1) continue;
                builder.append(separator2);
            }
        }
        builder.append(end);
        return builder.toString();
    }

    public static String firstWord(Tag tag) {
        return tag.text().split("\\s")[0];
    }

    public static String restOfSentence(Tag tag) {
        return tag.text().substring(RestdocWriter.firstWord(tag).length());
    }

    protected String asReference(Type type) {
        List<Type> types = this.getParameterizedTypes(type);
        if (types.isEmpty()) {
            return type.qualifiedTypeName() + ".html";
        }
        return types.get(0) + "-" + type.simpleTypeName() + ".html";
    }

    public List<Type> getParameterizedTypes(Type type) {
        ArrayList<Type> types = new ArrayList<Type>();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            for (Type param : paramType.typeArguments()) {
                types.add(param);
            }
        }
        return types;
    }

    protected Object renderType(Type type) {
        String returnTypeText = this.asText(type);
        String externalFile = this.asReference(type);
        if (FileCatalog.SINGLETON.check(externalFile)) {
            returnTypeText = this.link(externalFile, new Object[]{returnTypeText});
        }
        for (Type paramType : this.getParameterizedTypes(type)) {
            FileCatalog.SINGLETON.check(this.asReference(paramType));
        }
        return returnTypeText;
    }
}

