/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.google.common.base.Strings;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.rest.doclet.FileCatalog;
import com.xebialabs.rest.doclet.RestDoclet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RestdocWriter
extends HtmlWriter {
    private final FileCatalog fileCatalog = FileCatalog.SINGLETON;

    public RestdocWriter(PrintWriter writer) {
        super(writer);
    }

    protected String asText(Tag[] tags) {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : tags) {
            if (tag instanceof SeeTag) {
                this.appendLink(builder, (SeeTag)tag);
                continue;
            }
            if (tag.name().equals("@code")) {
                builder.append(this.code(new Object[]{tag.text()}));
                continue;
            }
            builder.append(tag.text());
        }
        return builder.toString();
    }

    private void appendLink(StringBuilder builder, SeeTag tag) {
        String file = RestDoclet.fileNameFor(tag.referencedClassName());
        String text = tag.text();
        if (!Strings.isNullOrEmpty((String)tag.label())) {
            text = tag.label();
        }
        if (file != null && this.fileCatalog.check(file)) {
            builder.append(this.link(file, new Object[]{text}));
        } else {
            builder.append(this.bold(new Object[]{text}));
        }
    }

    protected String asText(Type type) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.simpleTypeName());
        String separator = " of ";
        for (Type paramType : this.getParameterizedTypes(type)) {
            builder.append(separator);
            builder.append(paramType.simpleTypeName());
            separator = ", ";
        }
        return builder.toString();
    }

    public static String firstWord(Tag tag) {
        return tag.text().split("\\s")[0];
    }

    public static String restOfSentence(Tag tag) {
        return tag.text().substring(RestdocWriter.firstWord(tag).length());
    }

    protected String asReference(Type type) {
        List<Type> types = this.getParameterizedTypes(type);
        if (types.isEmpty()) {
            return type.qualifiedTypeName() + ".html";
        }
        return types.get(0) + "-" + type.simpleTypeName() + ".html";
    }

    public List<Type> getParameterizedTypes(Type type) {
        ArrayList<Type> types = new ArrayList<Type>();
        ParameterizedType paramType = type.asParameterizedType();
        if (paramType != null) {
            for (Type param : paramType.typeArguments()) {
                types.add(param);
            }
        }
        return types;
    }

    protected Object renderType(Type type) {
        String returnTypeText = this.asText(type);
        String externalFile = this.asReference(type);
        if (this.fileCatalog.check(externalFile)) {
            returnTypeText = this.link(externalFile, new Object[]{returnTypeText});
        }
        for (Type paramType : this.getParameterizedTypes(type)) {
            this.fileCatalog.check(this.asReference(paramType));
        }
        return returnTypeText;
    }
}

