package com.xebialabs.xlplatform.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;

import static java.lang.String.format;

public abstract class ResourceTestUtils {

    private ResourceTestUtils() {
        // utility class
    }

    public static String getResourceAsString(String resourceName, Charset charset) throws IOException {
        ClassLoader loader = firstNonNull(Thread.currentThread().getContextClassLoader(), ResourceTestUtils.class.getClassLoader());
        String res = null;
        try (InputStream fileStream = loader.getResourceAsStream(resourceName)) {
            if (null == fileStream) {
                throw new IllegalArgumentException(format("resource %s not found.", resourceName));
            }
            try (InputStreamReader isr = new InputStreamReader(fileStream, charset)) {
                StringWriter sw = new StringWriter();
                char[] buf = new char[4096];
                int len = 0;
                while((len = isr.read(buf)) != -1) {
                    sw.write(buf, 0, len);
                    sw.flush();
                }
                res = sw.toString();
            }
        }

        return res;
    }

    public static String getResourceAsString(String resourceName) throws IOException {
        return getResourceAsString(resourceName, Charset.forName("UTF-8"));
    }

    public static URL getResource(String resourceName) {
        ClassLoader loader = firstNonNull(Thread.currentThread().getContextClassLoader(), ResourceTestUtils.class.getClassLoader());
        URL url = loader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(format("resource %s not found.", resourceName));
        }
        return url;
    }

    private static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            return first;
        } else if (second != null) {
            return second;
        } else {
            throw new NullPointerException();
        }
    }


}
