package com.xebialabs.satellite.streaming

import java.security.MessageDigest
import javax.xml.bind.annotation.adapters.HexBinaryAdapter

import akka.util.ByteString
import org.reactivestreams.{Subscription, Subscriber}

trait StreamDigester extends Subscriber[ByteString] {

  private var subscription: Subscription = _

  private val adapter = new HexBinaryAdapter()

  private val digester = MessageDigest.getInstance("SHA-1")

  var fileLength = 0L

  override def onSubscribe(s: Subscription) {
    this.subscription = s
    s.request(1)
  }

  override def onError(t: Throwable) {
  }

  def checksum: String = adapter.marshal(digester.digest())


  override def onNext(bytes: ByteString) {
    digester.update(bytes.toByteBuffer)
    subscription.request(1)
    fileLength += bytes.length
  }
}
