/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.satellite.streaming;

import akka.NotUsed;
import akka.stream.scaladsl.Flow;
import akka.stream.stage.Context;
import akka.stream.stage.PushStage;
import akka.stream.stage.SyncDirective;
import akka.stream.stage.TerminationDirective;
import akka.util.ByteString;
import com.xebialabs.satellite.streaming.DigesterStage$;
import java.security.MessageDigest;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import scala.Function1;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t5s!B\u0001\u0003\u0011\u0003Y\u0011!\u0004#jO\u0016\u001cH/\u001a:Ti\u0006<WM\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t\u0011b]1uK2d\u0017\u000e^3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0004#jO\u0016\u001cH/\u001a:Ti\u0006<Wm\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\u0006\tii\u0001a\u0007\u0002\u000e!J|7-Z:t\t&<Wm\u001d;\u0011\u000bEab$a\u0005\n\u0005u\u0011\"!\u0003$v]\u000e$\u0018n\u001c82!\ty\u0002%D\u0001\u000e\r\u0011\tS\u0002\u0011\u0012\u0003\r\u0011Kw-Z:u'\u0011\u0001\u0003c\t\u0014\u0011\u0005E!\u0013BA\u0013\u0013\u0005\u001d\u0001&o\u001c3vGR\u0004\"!E\u0014\n\u0005!\u0012\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0016!\u0005+\u0007I\u0011A\u0016\u0002\u0011\rDWmY6tk6,\u0012\u0001\f\t\u0003[Ar!!\u0005\u0018\n\u0005=\u0012\u0012A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\n\t\u0011Q\u0002#\u0011#Q\u0001\n1\n\u0011b\u00195fG.\u001cX/\u001c\u0011\t\u0011Y\u0002#Q3A\u0005\u0002]\nAa]5{KV\t\u0001\b\u0005\u0002\u0012s%\u0011!H\u0005\u0002\u0005\u0019>tw\r\u0003\u0005=A\tE\t\u0015!\u00039\u0003\u0015\u0019\u0018N_3!\u0011\u00159\u0002\u0005\"\u0001?)\rqr\b\u0011\u0005\u0006Uu\u0002\r\u0001\f\u0005\u0006mu\u0002\r\u0001\u000f\u0005\b\u0005\u0002\n\t\u0011\"\u0001D\u0003\u0011\u0019w\u000e]=\u0015\u0007y!U\tC\u0004+\u0003B\u0005\t\u0019\u0001\u0017\t\u000fY\n\u0005\u0013!a\u0001q!9q\tII\u0001\n\u0003A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u0013*\u0012AFS\u0016\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0015\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002S\u001b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fQ\u0003\u0013\u0013!C\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#\u0001,+\u0005aR\u0005b\u0002-!\u0003\u0003%\t%W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tD\fC\u0004cA\u0005\u0005I\u0011A2\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0011\u0004\"!E3\n\u0005\u0019\u0014\"aA%oi\"9\u0001\u000eIA\u0001\n\u0003I\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003U6\u0004\"!E6\n\u00051\u0014\"aA!os\"9anZA\u0001\u0002\u0004!\u0017a\u0001=%c!9\u0001\u000fIA\u0001\n\u0003\n\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003I\u00042a\u001d<k\u001b\u0005!(BA;\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003oR\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bs\u0002\n\t\u0011\"\u0001{\u0003!\u0019\u0017M\\#rk\u0006dGCA>\u007f!\t\tB0\u0003\u0002~%\t9!i\\8mK\u0006t\u0007b\u00028y\u0003\u0003\u0005\rA\u001b\u0005\n\u0003\u0003\u0001\u0013\u0011!C!\u0003\u0007\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002I\"I\u0011q\u0001\u0011\u0002\u0002\u0013\u0005\u0013\u0011B\u0001\ti>\u001cFO]5oOR\t!\fC\u0005\u0002\u000e\u0001\n\t\u0011\"\u0011\u0002\u0010\u00051Q-];bYN$2a_A\t\u0011!q\u00171BA\u0001\u0002\u0004Q\u0007cA\t\u0002\u0016%\u0019\u0011q\u0003\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u00037iA\u0011AA\u000f\u0003\u00111Gn\\<\u0015\t\u0005}\u0011q\t\t\u000b\u0003C\ty#a\r\u00024\u0005}RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0011M\u001c\u0017\r\\1eg2TA!!\u000b\u0002,\u000511\u000f\u001e:fC6T!!!\f\u0002\t\u0005\\7.Y\u0005\u0005\u0003c\t\u0019C\u0001\u0003GY><\b\u0003BA\u001b\u0003wi!!a\u000e\u000b\t\u0005e\u00121F\u0001\u0005kRLG.\u0003\u0003\u0002>\u0005]\"A\u0003\"zi\u0016\u001cFO]5oOB!\u0011\u0011IA\"\u001b\t\tY#\u0003\u0003\u0002F\u0005-\"a\u0002(piV\u001bX\r\u001a\u0005\t\u0003\u0013\nI\u00021\u0001\u0002L\u0005QqN\\\"p[BdW\r^3\u0011\u0005}IbABA(\u001b\u0011\t\tF\u0001\bTiJ,\u0017-\u001c#jO\u0016\u001cH/\u001a:\u0014\t\u00055\u00131\u000b\t\t\u0003+\nY&a\r\u000245\u0011\u0011q\u000b\u0006\u0005\u00033\n9#A\u0003ti\u0006<W-\u0003\u0003\u0002^\u0005]#!\u0003)vg\"\u001cF/Y4f\u0011-\tI%!\u0014\u0003\u0002\u0003\u0006I!a\u0013\t\u000f]\ti\u0005\"\u0001\u0002dQ!\u0011QMA4!\ry\u0012Q\n\u0005\t\u0003\u0013\n\t\u00071\u0001\u0002L!Q\u00111NA'\u0005\u0004%I!!\u001c\u0002\u0011\u0011Lw-Z:uKJ,\"!a\u001c\u0011\u0007}\t\tHB\u0004\u0002t5\u0001!!!\u001e\u0003\u0011\u0011Kw-Z:uKJ\u001c2!!\u001d\u0011\u0011\u001d9\u0012\u0011\u000fC\u0001\u0003s\"\"!a\u001c\t\u0015\u0005u\u0014\u0011\u000fb\u0001\n\u0013\ty(A\u0004bI\u0006\u0004H/\u001a:\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003/k!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\tC\u0012\f\u0007\u000f^3sg*\u0019\u0001+a#\u000b\t\u00055\u0015qR\u0001\u0005E&tGM\u0003\u0003\u0002\u0012\u0006M\u0015a\u0001=nY*\u0011\u0011QS\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u00033\u000b)I\u0001\tIKb\u0014\u0015N\\1ss\u0006#\u0017\r\u001d;fe\"I\u0011QTA9A\u0003%\u0011\u0011Q\u0001\tC\u0012\f\u0007\u000f^3sA!Q\u00111NA9\u0005\u0004%I!!)\u0016\u0005\u0005\r\u0006\u0003BAS\u0003Wk!!a*\u000b\u0007\u0005%f,\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\ti+a*\u0003\u001b5+7o]1hK\u0012Kw-Z:u\u0011%\t\t,!\u001d!\u0002\u0013\t\u0019+A\u0005eS\u001e,7\u000f^3sA!Aa'!\u001dA\u0002\u0013\u0005q\u0007\u0003\u0006\u00028\u0006E\u0004\u0019!C\u0001\u0003s\u000b\u0001b]5{K~#S-\u001d\u000b\u0005\u0003'\tY\f\u0003\u0005o\u0003k\u000b\t\u00111\u00019\u0011\u001da\u0014\u0011\u000fQ!\naB\u0001\"!1\u0002r\u0011\u0005\u00111Y\u0001\u0007kB$\u0017\r^3\u0015\t\u0005M\u0011Q\u0019\u0005\t\u0003\u000f\fy\f1\u0001\u0002J\u0006)!-\u001f;fgB)\u0011#a3\u0002P&\u0019\u0011Q\u001a\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\t\t.C\u0002\u0002TJ\u0011AAQ=uK\"A\u0011q[A9\t\u0003\tI.\u0001\u0004eS\u001e,7\u000f\u001e\u000b\u0002=!I\u0011\u0011WA'A\u0003%\u0011q\u000e\u0005\t\u0003?\fi\u0005\"\u0011\u0002b\u00061qN\u001c)vg\"$b!a9\u0002j\u00065\b\u0003BA+\u0003KLA!a:\u0002X\ti1+\u001f8d\t&\u0014Xm\u0019;jm\u0016D\u0001\"a;\u0002^\u0002\u0007\u00111G\u0001\u0005K2,W\u000e\u0003\u0005\u0002p\u0006u\u0007\u0019AAy\u0003\r\u0019G\u000f\u001f\t\u0007\u0003+\n\u00190a\r\n\t\u0005U\u0018q\u000b\u0002\b\u0007>tG/\u001a=u\u0011!\tI0!\u0014\u0005B\u0005m\u0018\u0001E8o+B\u001cHO]3b[\u001aKg.[:i)\u0011\tiPa\u0001\u0011\t\u0005U\u0013q`\u0005\u0005\u0005\u0003\t9F\u0001\u000bUKJl\u0017N\\1uS>tG)\u001b:fGRLg/\u001a\u0005\t\u0003_\f9\u00101\u0001\u0002r\u001eI!qA\u0007\u0002\u0002#\u0005!\u0011B\u0001\u0007\t&<Wm\u001d;\u0011\u0007}\u0011YA\u0002\u0005\"\u001b\u0005\u0005\t\u0012\u0001B\u0007'\u0015\u0011YAa\u0004'!\u001d\u0011\tBa\u0006-qyi!Aa\u0005\u000b\u0007\tU!#A\u0004sk:$\u0018.\\3\n\t\te!1\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\f\u0003\f\u0011\u0005!Q\u0004\u000b\u0003\u0005\u0013A!\"a\u0002\u0003\f\u0005\u0005IQIA\u0005\u0011)\u0011\u0019Ca\u0003\u0002\u0002\u0013\u0005%QE\u0001\u0006CB\u0004H.\u001f\u000b\u0006=\t\u001d\"\u0011\u0006\u0005\u0007U\t\u0005\u0002\u0019\u0001\u0017\t\rY\u0012\t\u00031\u00019\u0011)\u0011iCa\u0003\u0002\u0002\u0013\u0005%qF\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tD!\u0010\u0011\u000bE\u0011\u0019Da\u000e\n\u0007\tU\"C\u0001\u0004PaRLwN\u001c\t\u0006#\teB\u0006O\u0005\u0004\u0005w\u0011\"A\u0002+va2,'\u0007C\u0005\u0003@\t-\u0012\u0011!a\u0001=\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\r#1BA\u0001\n\u0013\u0011)%A\u0006sK\u0006$'+Z:pYZ,GC\u0001B$!\rY&\u0011J\u0005\u0004\u0005\u0017b&AB(cU\u0016\u001cG\u000f")
public final class DigesterStage {
    public static Flow<ByteString, ByteString, NotUsed> flow(Function1<Digest, BoxedUnit> function1) {
        return DigesterStage$.MODULE$.flow(function1);
    }

    public static class Digest
    implements Product,
    Serializable {
        private final String checksum;
        private final long size;

        public String checksum() {
            return this.checksum;
        }

        public long size() {
            return this.size;
        }

        public Digest copy(String checksum, long size) {
            return new Digest(checksum, size);
        }

        public String copy$default$1() {
            return this.checksum();
        }

        public long copy$default$2() {
            return this.size();
        }

        public String productPrefix() {
            return "Digest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                case 0: {
                    object = this.checksum();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Digest;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.checksum()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Digest)) return false;
            boolean bl = true;
            if (!bl) return false;
            Digest digest = (Digest)x$1;
            String string = this.checksum();
            String string2 = digest.checksum();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.size() != digest.size()) return false;
            if (!digest.canEqual(this)) return false;
            return true;
        }

        public Digest(String checksum, long size) {
            this.checksum = checksum;
            this.size = size;
            Product.class.$init$((Product)this);
        }
    }

    public static class Digester {
        private final HexBinaryAdapter adapter = new HexBinaryAdapter();
        private final MessageDigest digester = MessageDigest.getInstance("SHA-1");
        private long size = 0L;

        private HexBinaryAdapter adapter() {
            return this.adapter;
        }

        private MessageDigest digester() {
            return this.digester;
        }

        public long size() {
            return this.size;
        }

        public void size_$eq(long x$1) {
            this.size = x$1;
        }

        public void update(byte[] bytes) {
            this.size_$eq(this.size() + (long)bytes.length);
            this.digester().update(bytes);
        }

        public Digest digest() {
            return new Digest(this.adapter().marshal(this.digester().digest()), this.size());
        }
    }

    public static class StreamDigester
    extends PushStage<ByteString, ByteString> {
        private final Function1<Digest, BoxedUnit> onComplete;
        private final Digester digester;

        private Digester digester() {
            return this.digester;
        }

        public SyncDirective onPush(ByteString elem, Context<ByteString> ctx) {
            this.digester().update((byte[])elem.toArray(ClassTag$.MODULE$.Byte()));
            return ctx.push((Object)elem);
        }

        public TerminationDirective onUpstreamFinish(Context<ByteString> ctx) {
            this.onComplete.apply((Object)this.digester().digest());
            return super.onUpstreamFinish(ctx);
        }

        public StreamDigester(Function1<Digest, BoxedUnit> onComplete) {
            this.onComplete = onComplete;
            this.digester = new Digester();
        }
    }
}

