/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.satellite.streaming;

import akka.NotUsed;
import akka.stream.BidiShape;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.TLSProtocol;
import akka.stream.TLSRole;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.TLS$;
import akka.stream.scaladsl.TLSPlacebo$;
import akka.util.ByteString;
import com.xebialabs.satellite.streaming.SslStreamingSupport;
import com.xebialabs.xlplatform.settings.SecuritySettings;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SslStreamingSupport$
implements Logging {
    public static final SslStreamingSupport$ MODULE$;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    static {
        new SslStreamingSupport$();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SslStreamingSupport$ sslStreamingSupport$ = this;
        synchronized (sslStreamingSupport$) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public <Mat> Flow<ByteString, ByteString, Mat> wrapWithSsl(SslStreamingSupport.SslConfig sslConfig, Flow<ByteString, ByteString, Mat> tcpConnection) {
        return this.sslWrapper(this.sslFlow(sslConfig), tcpConnection, sslConfig.role());
    }

    private BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> sslFlow(SslStreamingSupport.SslConfig sslConfig) {
        boolean bl;
        block4: {
            BidiFlow bidiFlow;
            block3: {
                block2: {
                    bl = sslConfig.enabled();
                    if (!bl) break block2;
                    this.debug((Function0<Object>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Real ssl config";
                        }
                    });
                    bidiFlow = TLS$.MODULE$.apply(sslConfig.sslContext(), this.newSessionNegotiation(sslConfig.enabledAlgorithms()), sslConfig.role(), sslConfig.closing(), TLS$.MODULE$.apply$default$5());
                    break block3;
                }
                if (bl) break block4;
                this.debug((Function0<Object>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Placebo ssl config";
                    }
                });
                bidiFlow = TLSPlacebo$.MODULE$.apply();
            }
            return bidiFlow;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private TLSProtocol.NegotiateNewSession newSessionNegotiation(Seq<String> cypherSuites) {
        return TLSProtocol.NegotiateNewSession$.MODULE$.withCipherSuites(cypherSuites);
    }

    private <Mat> Flow<ByteString, ByteString, Mat> sslWrapper(BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, ?> sslFlow2, Flow<ByteString, ByteString, Mat> tcpConnection, TLSRole role) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(sslFlow2, tcpConnection, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Mat apply(Object x$1, Mat c) {
                return c;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<BidiShape<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound>, FlowShape<ByteString, ByteString>, FlowShape<ByteString, ByteString>> apply(GraphDSL.Builder<Mat> builder) {
                return new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final GraphDSL.Builder builder$1;

                    public final FlowShape<ByteString, ByteString> apply(BidiShape<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound> sslFlow2, FlowShape<ByteString, ByteString> conn) {
                        FlowShape sendBytes = (FlowShape)this.builder$1.add((Graph)Flow$.MODULE$.apply().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TLSProtocol.SendBytes apply(ByteString bs) {
                                return new TLSProtocol.SendBytes(bs);
                            }
                        }));
                        GraphDSL.Implicits$.MODULE$.port2flow(GraphDSL.Implicits$.MODULE$.flow2flow(sendBytes, this.builder$1).outlet(), this.builder$1).$tilde$greater(sslFlow2.in1(), this.builder$1);
                        GraphDSL.Implicits$.MODULE$.port2flow(sslFlow2.out1(), this.builder$1).$tilde$greater(conn, this.builder$1).$tilde$greater(sslFlow2.in2(), this.builder$1);
                        GraphDSL.Implicits$.PortOps inboundFlow = (GraphDSL.Implicits$.PortOps)GraphDSL.Implicits$.MODULE$.port2flow(sslFlow2.out2(), this.builder$1).collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof TLSProtocol.SessionBytes) {
                                    TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                                    ByteString bytes = sessionBytes.bytes();
                                    object = bytes;
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                                TLSProtocol.SslTlsInbound sslTlsInbound = x1;
                                boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
                                return bl;
                            }
                        });
                        return new FlowShape(sendBytes.in(), inboundFlow.outlet());
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                };
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext initSslContext(SecuritySettings settings) {
        void var2_2;
        SSLContext context = SSLContext.getInstance(settings.protocol());
        context.init(this.createKeyManagersIfPossible(settings), this.createTrustManagers(settings), new SecureRandom());
        return var2_2;
    }

    private KeyManager[] createKeyManagersIfPossible(SecuritySettings settings) {
        return (KeyManager[])Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.option2Iterable(settings.keyStore().map((Function1)new Serializable(settings){
            public static final long serialVersionUID = 0L;
            private final SecuritySettings settings$1;

            public final KeyManager[] apply(String ks) {
                return SslStreamingSupport$.MODULE$.com$xebialabs$satellite$streaming$SslStreamingSupport$$createKeyManager$1(ks, this.settings$1.keyStorePassword().toCharArray(), this.settings$1.keyPassword().toCharArray());
            }
            {
                this.settings$1 = settings$1;
            }
        })).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(KeyManager.class)))).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<KeyManager> apply(KeyManager[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(KeyManager.class));
    }

    private TrustManager[] createTrustManagers(SecuritySettings settings) {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(this.loadResource(settings.trustStore()), settings.trustStorePassword().toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private InputStream loadResource(String resource) {
        return (InputStream)Option$.MODULE$.apply((Object)ClassLoaderUtils$.MODULE$.classLoader().getResourceAsStream(resource)).getOrElse((Function0)new Serializable(resource){
            public static final long serialVersionUID = 0L;
            private final String resource$1;

            public final FileInputStream apply() {
                return new FileInputStream(this.resource$1);
            }
            {
                this.resource$1 = resource$1;
            }
        });
    }

    public final KeyManager[] com$xebialabs$satellite$streaming$SslStreamingSupport$$createKeyManager$1(String keyStoreResource, char[] keyStorePassword, char[] keyPassword) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(this.loadResource(keyStoreResource), keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyPassword);
        return keyManagerFactory.getKeyManagers();
    }

    private SslStreamingSupport$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

