package com.xebialabs.satellite.protocol

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState
import com.xebialabs.deployit.engine.tasker.{BlockId, TaskId}
import com.xebialabs.satellite.protocol.TaskSpecificationExchange._


sealed trait TaskReply

case object Registered extends TaskReply

case object AlreadyRegistered extends TaskReply

case class RegistrationFailedForMissingStep(missing: Seq[StepType]) extends TaskReply

case class RegistrationFailedForUnexpectedError(e: Throwable) extends TaskReply

case class RegistrationFailedForMissingFiles(missingFiles: Set[String]) extends TaskReply

case class RegistrationFailedForMissingArtifactsImplem(missingArtifactsImplem: Seq[String]) extends TaskReply

case class TaskSpecificationExchange(stepTypes: Seq[StepType], bytes: Array[Byte], taskId: TaskId, fileIds: Set[String], artifactTypes: Seq[ArtifactType])

case class CleanUpTask(taskId: TaskId)

object TaskSpecificationExchange {

  type StepType = String
  type ArtifactType = String

}
