package com.xebialabs.xlplatform.settings

import java.io.File

import akka.actor.{ExtendedActorSystem, Extension, ExtensionId, ExtensionIdProvider}
import akka.util.Timeout
import com.typesafe.config.Config

import scala.concurrent.duration._
import scala.language.postfixOps

object CommonSettings extends ExtensionId[CommonSettings] with ExtensionIdProvider {

  override def createExtension(system: ExtendedActorSystem): CommonSettings = new CommonSettings(system.settings.config)

  override def lookup(): ExtensionId[_ <: Extension] = CommonSettings
}

class CommonSettings(config: Config) extends Extension {
  lazy val tasker = new TaskerSettings(config)
  lazy val satellite = new SatelliteSettings(config)
  lazy val scheduler = new SchedulerSettings(config)
  lazy val security = new SecuritySettings(config.getConfig("satellite.ssl"))
}

class TaskerSettings(val config: Config) extends SettingsSupport {
  lazy val recoveryDir = new File(value[String]("task.recovery-dir"))
  lazy val maxActiveTasks: Int = value[Int]("task.max-active-tasks")
  lazy val shutdownTimeout: FiniteDuration = value[FiniteDuration]("task.shutdown-timeout")
  lazy val tickDuration: FiniteDuration = value[FiniteDuration]("akka.scheduler.tick-duration")
  lazy val stepRetryDelay: FiniteDuration = value[FiniteDuration]("task.step.retry-delay")
  lazy val askTimeout: Timeout = valueWithDefault("tasker.askTimeout", 10 seconds)
  lazy val stepRunTimeout: FiniteDuration = valueWithDefault("task.step.run-timeout", 6 hours)
}

class SatelliteSettings(val config: Config) extends SettingsSupport {
  lazy val uploadIdleTimeout: Timeout = valueWithDefault("satellite.timeout.upload.idle", 10 seconds)
  lazy val pingTimeout: Timeout = valueWithDefault("satellite.timeout.ping", 5 seconds)
  lazy val remoteAskTimeout: Timeout = valueWithDefault("satellite.timeout.remoteAsk", 60 seconds)
  lazy val hostname: String = value[String]("satellite.hostname")
  lazy val enabled: Boolean = valueWithDefault("satellite.enabled", false)
  lazy val streamingConnectionTimeout: Timeout = valueWithDefault("satellite.timeout.streaming", 10 seconds)
  lazy val maxConcurrentUploads: Int = valueWithDefault("satellite.streaming.max-uploads", 10)
}

class SchedulerSettings(val config: Config) extends SettingsSupport {
  lazy val tickDuration: FiniteDuration = value[FiniteDuration]("akka.scheduler.tick-duration")
}