package com.xebialabs.deployit.engine.tasker.satellite

import java.io.{ByteArrayInputStream, ByteArrayOutputStream}

import akka.serialization.{Serializer => AkkaSerializer}
import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.{Input, Output}

import scala.reflect.ClassTag


trait BaseMessageSerializer[T <: AnyRef] extends AkkaSerializer {

  val kryo: Kryo

  val classTag: ClassTag[T]

  override def fromBinary(bytes: Array[Byte], manifest: Option[Class[_]]): AnyRef = {
    val input = new Input(new ByteArrayInputStream(bytes))

    kryo.readObject(input, classTag.runtimeClass.asInstanceOf[Class[AnyRef]])
  }

  override def toBinary(obj: AnyRef): Array[Byte] = {
    import com.xebialabs.xlplatform.utils.ResourceManagement._
    val stream = new ByteArrayOutputStream()
    using(new Output(stream)) { output =>
      kryo.writeObject(output, obj)
      output.flush()
    }
    stream.toByteArray
  }
}
