package com.xebialabs.deployit.engine.tasker

import akka.actor.Props
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator

sealed trait SatelliteBlockRouter {

  def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: akka.actor.ActorContext): Props

}

object SatelliteBlockRouter {

  object Master extends SatelliteBlockRouter {

    def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: akka.actor.ActorContext): Props = routeToSatellite(task, block, ctx) getOrElse {
      block match {
        case cb: CompositeBlock => BlockExecutingActor.props(task, cb, ctx, Master)
        case sb: StepBlock => StepBlockExecutingActor.props(task, sb, ctx)
      }
    }

    private def routeToSatellite(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: akka.actor.ActorContext): Option[Props] = {
      block.satellite.map(sat => {
        BlockOnSatellite.props(task, block, ActorLocator(sat), context.self)
      })
    }
  }

  object Satellite extends SatelliteBlockRouter {

    def route(task: Task, block: ExecutableBlock, ctx: TaskExecutionContext)(implicit context: akka.actor.ActorContext): Props = block match {
      case sb: StepBlock => StepBlockExecutingActor.props(task, sb, ctx)
      case cb: CompositeBlock => BlockExecutingActor.props(task, cb, ctx, Master)
    }
  }

}