package com.xebialabs.xlplatform.test.tasksystem

import com.xebialabs.deployit.security.SecretKeyHolder
import com.xebialabs.deployit.util.DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY
import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter}

trait SecuritySupport {

  def initSecurity(): Unit = {
    SecretKeyHolder.init(DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY)
  }

  def cleanSecurity(): Unit = {
    SecretKeyHolder.reset()
  }

  def initPasswordEncrypter(): Unit = {
    PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY)
  }
}

