package com.xebialabs.xlplatform.tests.runner

import java.io.File

import com.xebialabs.xlplatform.tests.runner.CliScriptsFunSuite.{AroundScriptFinder, TestScriptFilter, TestScriptFinder}
import org.scalatest.FunSpecLike

import scalax.file.Path
import scalax.file.PathMatcherFactory.RegexToMatcher


object CliScriptsFunSuite {

  import Implicits._

  type AroundScriptFinder = Path => Seq[Path]

  type TestScriptFinder = () => Seq[Path]

  type TestScriptFilter = (Path) => Boolean

  val setupScriptFinder: AroundScriptFinder = _.parent.map(_ / "setup.py").get.toNilIfNotExists

  val tearDownScriptFinder: AroundScriptFinder = _.parent.map(_ / "teardown.py").get.toNilIfNotExists

  val excludeAroundScriptsFilter: TestScriptFilter = path => path.name != "setup.py" && path.name != "teardown.py"

}

trait CliScriptsFunSuite extends CliScriptRunner {
  this: FunSpecLike =>

  import Implicits._

  val testConfig: TestConfig

  private lazy val baseDir = Path(new File(testConfig.runner.baseDirectory))
  private lazy val enabledItests = (baseDir / "enabled-itests").toNilIfNotExists.flatMap(_.lines().toSeq)

  lazy val scriptsFinder: TestScriptFinder = () => {
    val pathSet = baseDir ** "(.+)[.](py|cli)".r
    pathSet.toSeq
  }

  lazy val scriptFileNameRegexFilter: TestScriptFilter = path => {
    val regex = testConfig.runner.scriptFileNameRegex.r
    path.name match {
      case regex() =>
        true
      case _ =>
        false
    }
  }

  lazy val scriptFileInEnabledListFilter: TestScriptFilter = path => {
    enabledItests.isEmpty || enabledItests.contains(path.name)
  }

  def itShouldRunScripts(scriptFinder: TestScriptFinder = scriptsFinder,
                         scriptFilters: Seq[TestScriptFilter] = Seq(CliScriptsFunSuite.excludeAroundScriptsFilter, scriptFileNameRegexFilter, scriptFileInEnabledListFilter),
                         setupScriptFinder: AroundScriptFinder = CliScriptsFunSuite.setupScriptFinder,
                         teardownScriptFinder: AroundScriptFinder = CliScriptsFunSuite.tearDownScriptFinder): Unit = {
    require(baseDir.exists, s"Cannot find path ${baseDir.toAbsolute.path}")
    describe("Script") {
      val allScripts = scriptFinder()
      val filteredScripts = allScripts.filter(script => scriptFilters.forall(_.apply(script)))
      filteredScripts.foreach { script =>
        it(script.relativize(baseDir).path) {
          println("Running " + script.path)
          implicit val interpreter = newInterpreter
          try {
            setupScriptFinder(script).foreach(setup => executeScriptByPath(setup.path))
            executeScriptByPath(script.path)
          } finally {
            teardownScriptFinder(script).foreach(teardown => executeScriptByPath(teardown.path))
          }
        }
      }
    }
  }
}
