package com.xebialabs.xlplatform.tests.utils

import com.google.common.util.concurrent.ListenableFuture
import com.xebialabs.deployit.itest.cloudhost.{CloudHostFutureTransformer, ItestHostLauncher}
import com.xebialabs.overcast.host.CloudHost

trait OvercastTopologySupport  {

  def defaultOvercastName: String

  def overcastSuffix: String = ""

  def overcastName: String = System.getProperty("itestcfg", defaultOvercastName)

  def launcherTransformers: Seq[CloudHostFutureTransformer] = Nil

  lazy val isOvercastHostEnabled = overcastName.endsWith(overcastSuffix)

  private var target: CloudHost = null

  def createOvercastTarget = {
    val launcher: ItestHostLauncher = ItestHostLauncher.getInstance
    launcherTransformers.foreach(launcher.addTransformer)
    val targetHost: ListenableFuture[CloudHost] = launcher.launch(overcastName)
    target = targetHost.get
    target
  }

  def closeOvercastTarget(): Unit = {
    target.teardown()
  }
}
