from java.lang.System import getProperty
import json


def if_none(value, default):
    if value is None:
        return default
    else:
        return value


def extract_ids(cis):
    return map(lambda ci: ci.id, cis)


def os_family():
    import java.lang.System
    if "windows" in java.lang.System.getProperty('os.name').lower():
        return "WINDOWS"
    else:
        return "UNIX"


def get_tmp_folder(folder_name):
    localtemp = getProperty('java.io.tmpdir')
    return get_file_in_folder(localtemp, folder_name)


def get_file_in_folder(folder_name, file_name):
    seperator = getProperty('file.separator')
    if folder_name.endswith('/') or (folder_name.endswith('\\')):
        tmp_dir = folder_name + file_name
    else:
        tmp_dir = folder_name + seperator + file_name
    return tmp_dir


def pretty_print_dictionary(dict):
    print json.dumps(dict, sort_keys=True, indent=4)

