from utils import if_none

def assign_role(role_name, users=None, permissions=None):
    users = if_none(users, [])
    permissions = if_none(permissions, [])
    security.assignRole(role_name, users)
    security.grant('login', role_name)
    for p in permissions:
        security.grant(p['permission'], role_name, p['cis'])

def create_user(user_name, is_admin=False):
    return security.createUser(user_name, "password", is_admin).getUsername()

def login_as(username, password="password"):
    security.logout()
    security.login(username, password)

def delete_user(user):
    security.deleteUser(user)

def delete_role(role):
    security.removeRole(role)

