package com.xebialabs.xlplatform.endpoints.json

import spray.json.{JsValue, JsNull}
import com.xebialabs.xlplatform.endpoints.actors.ScriptDone

object ScriptResponse {
   def apply(scriptDone: ScriptDone): ScriptResponse = {
     new ScriptResponse(scriptDone.entity, scriptDone.stdout, scriptDone.stderr, scriptDone.exception)
   }
}

case class ScriptResponse(entity: Any, stdout: String, stderr: String, exception: Option[Throwable] = None) {}

case class ScriptRequest(query: Map[String, AnyRef], entity: JsValue = JsNull) {}
