package com.xebialabs.xlplatform


import akka.http.scaladsl.server.{PathMatcher0, Route}
import akka.http.scaladsl.server.Directives._

package object endpoints {
  type AuthenticatedRoute = AuthenticatedData => Route

  def segments(path: String): PathMatcher0 = {
    Option(path) match {
      case None | Some("") => Neutral
      case Some(string) if string.startsWith("/") => separateOnSlashes(string)
      case Some(string) => Slash ~ separateOnSlashes(string)
    }
  }
}
