package com.xebialabs.xlplatform.endpoints.servlet

import akka.actor.{ActorRefFactory, ActorSystem}
import akka.http.scaladsl.server.Route
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xlplatform.endpoints.ExtendableRestApi
import com.xebialabs.xlplatform.settings.XlPlatformSettings

class ServletBoot() extends ExtendableRestApi {
  val system = ActorSystem("extension-servlet-system")
  val actorRefFactory: ActorRefFactory = system

  lazy val settings: XlPlatformSettings = XlPlatformSettings(system)
  lazy val passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance()

  lazy val routes: Route = extendableRoutes
}

