package com.xebialabs.xlplatform.spring;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextHolder implements ApplicationContextAware {
    private static final AtomicReference<ApplicationContext> APPLICATION_CONTEXT = new AtomicReference<ApplicationContext>();

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.APPLICATION_CONTEXT.set(applicationContext);
    }

    public static ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT.get();
    }
}
