package com.xebialabs.xlplatform.endpoints.servlet

import com.typesafe.config.Config
import com.xebialabs.xlplatform.akka25.Akka25
import grizzled.slf4j.Logging

import javax.servlet.{ServletContext, ServletContextEvent, ServletContextListener}

class AkkaStreamServletInitializer(val config: Config) extends ServletContextListener with Logging {
  import AkkaStreamServletInitializer._
  private var boot: ServletBoot = _

  def this() = this(null)

  override def contextInitialized(sce: ServletContextEvent): Unit = {
    val ctx: ServletContext = sce.getServletContext
    logger.debug("Initializing AkkaStream servlet context")
    boot = new ServletBoot(config)

    ctx.setAttribute(SYSTEM_KEY, boot.system)
    ctx.setAttribute(ROUTES_KEY, boot.routes)
    ctx.setAttribute(TIMEOUT_KEY, boot.settings.ServerExtension.timeout.duration.toMillis)
  }

  override def contextDestroyed(sce: ServletContextEvent): Unit = {
    logger.debug("Terminating AkkaStream servlet context")
    Akka25.terminate(boot.system)
  }
}

object AkkaStreamServletInitializer {
  val SYSTEM_KEY = "akka-stream.servlet.system"
  val ROUTES_KEY = "akka-stream.servlet.routes"
  val TIMEOUT_KEY = "akka-stream.servlet.timeout"
}

